/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.bytecode.translators;

import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.representation.MethodDescriptor;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;

public class AsmObjectTranslator {
    public static Type translateType(Translator translator, Type type) {
        String descString = type.getDescriptor();
        switch (type.getSort()) {
            case 10: {
                ClassEntry classEntry = new ClassEntry(type.getInternalName());
                return Type.getObjectType(translator.translate(classEntry).getFullName());
            }
            case 9: {
                TypeDescriptor descriptor = new TypeDescriptor(descString);
                return Type.getType(translator.translate(descriptor).toString());
            }
            case 11: {
                MethodDescriptor descriptor = new MethodDescriptor(descString);
                return Type.getMethodType(translator.translate(descriptor).toString());
            }
        }
        return type;
    }

    public static Handle translateHandle(Translator translator, Handle handle) {
        boolean isFieldHandle = handle.getTag() <= 4;
        return isFieldHandle ? AsmObjectTranslator.translateFieldHandle(translator, handle) : AsmObjectTranslator.translateMethodHandle(translator, handle);
    }

    private static Handle translateMethodHandle(Translator translator, Handle handle) {
        MethodEntry entry = new MethodEntry(new ClassEntry(handle.getOwner()), handle.getName(), new MethodDescriptor(handle.getDesc()));
        MethodEntry translatedMethod = translator.translate(entry);
        ClassEntry ownerClass = (ClassEntry)translatedMethod.getParent();
        return new Handle(handle.getTag(), ownerClass.getFullName(), translatedMethod.getName(), translatedMethod.getDesc().toString(), handle.isInterface());
    }

    private static Handle translateFieldHandle(Translator translator, Handle handle) {
        FieldEntry entry = new FieldEntry(new ClassEntry(handle.getOwner()), handle.getName(), new TypeDescriptor(handle.getDesc()));
        FieldEntry translatedMethod = translator.translate(entry);
        ClassEntry ownerClass = (ClassEntry)translatedMethod.getParent();
        return new Handle(handle.getTag(), ownerClass.getFullName(), translatedMethod.getName(), translatedMethod.getDesc().toString(), handle.isInterface());
    }

    public static Object translateValue(Translator translator, Object value) {
        if (value instanceof Type) {
            return AsmObjectTranslator.translateType(translator, (Type)value);
        }
        if (value instanceof Handle) {
            return AsmObjectTranslator.translateHandle(translator, (Handle)value);
        }
        return value;
    }
}

