/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.representation.entry;

import cuchaz.enigma.api.view.entry.ClassDefEntryView;
import cuchaz.enigma.source.RenamableTokenType;
import cuchaz.enigma.translation.TranslateResult;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.representation.AccessFlags;
import cuchaz.enigma.translation.representation.Signature;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.DefEntry;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassDefEntry
extends ClassEntry
implements DefEntry<ClassEntry>,
ClassDefEntryView {
    private final AccessFlags access;
    private final Signature signature;
    @Nullable
    private final ClassEntry superClass;
    private final ClassEntry[] interfaces;

    public ClassDefEntry(String className, Signature signature, AccessFlags access, @Nullable ClassEntry superClass, ClassEntry[] interfaces) {
        this(ClassDefEntry.getOuterClass(className), ClassDefEntry.getInnerName(className), signature, access, superClass, interfaces, null);
    }

    public ClassDefEntry(ClassEntry parent, String className, Signature signature, AccessFlags access, @Nullable ClassEntry superClass, ClassEntry[] interfaces) {
        this(parent, className, signature, access, superClass, interfaces, null);
    }

    public ClassDefEntry(ClassEntry parent, String className, Signature signature, AccessFlags access, @Nullable ClassEntry superClass, ClassEntry[] interfaces, String javadocs) {
        super(parent, className, javadocs);
        this.signature = Objects.requireNonNull(signature, "Class signature cannot be null");
        this.access = Objects.requireNonNull(access, "Class access cannot be null");
        this.superClass = superClass;
        this.interfaces = interfaces != null ? interfaces : new ClassEntry[]{};
    }

    public static ClassDefEntry parse(int access, String name, String signature, String superName, String[] interfaces) {
        ClassEntry superClass = superName != null ? new ClassEntry(superName) : null;
        ClassEntry[] interfaceClasses = (ClassEntry[])Arrays.stream(interfaces).map(ClassEntry::new).toArray(ClassEntry[]::new);
        return new ClassDefEntry(name, Signature.createSignature(signature), new AccessFlags(access), superClass, interfaceClasses);
    }

    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public AccessFlags getAccess() {
        return this.access;
    }

    @Override
    @Nullable
    public ClassEntry getSuperClass() {
        return this.superClass;
    }

    public ClassEntry[] getInterfaces() {
        return this.interfaces;
    }

    public boolean isRecord() {
        return this.superClass != null && this.superClass.getName().equals("java/lang/Record");
    }

    @Override
    public TranslateResult<ClassDefEntry> extendedTranslate(Translator translator, @NotNull EntryMapping mapping) {
        Signature translatedSignature = translator.translate(this.signature);
        String translatedName = mapping.targetName() != null ? mapping.targetName() : this.name;
        AccessFlags translatedAccess = mapping.accessModifier().transform(this.access);
        ClassEntry translatedSuper = translator.translate(this.superClass);
        ClassEntry[] translatedInterfaces = (ClassEntry[])Arrays.stream(this.interfaces).map(translator::translate).toArray(ClassEntry[]::new);
        String docs = mapping.javadoc();
        return TranslateResult.of(mapping.targetName() == null ? RenamableTokenType.OBFUSCATED : RenamableTokenType.DEOBFUSCATED, new ClassDefEntry((ClassEntry)this.parent, translatedName, translatedSignature, translatedAccess, translatedSuper, translatedInterfaces, docs));
    }

    @Override
    public ClassDefEntry withName(String name) {
        return new ClassDefEntry((ClassEntry)this.parent, name, this.signature, this.access, this.superClass, this.interfaces, this.javadocs);
    }

    @Override
    public ClassDefEntry withParent(ClassEntry parent) {
        return new ClassDefEntry(parent, this.name, this.signature, this.access, this.superClass, this.interfaces, this.javadocs);
    }
}

