/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.GuiController;
import cuchaz.enigma.gui.NestedPackages;
import cuchaz.enigma.gui.node.ClassSelectorClassNode;
import cuchaz.enigma.gui.util.GuiUtil;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.utils.validation.ValidationContext;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ClassSelector
extends JTree {
    public static final Comparator<ClassEntry> DEOBF_CLASS_COMPARATOR = Comparator.comparing(ClassEntry::getFullName);
    private final Comparator<ClassEntry> comparator;
    private final GuiController controller;
    private NestedPackages packageManager;
    private ClassSelectionListener selectionListener;
    private RenameSelectionListener renameSelectionListener;

    public ClassSelector(final Gui gui, Comparator<ClassEntry> comparator, final boolean isRenamable) {
        this.comparator = comparator;
        this.controller = gui.getController();
        this.setEditable(true);
        this.setRootVisible(false);
        this.setShowsRootHandles(false);
        this.setModel(null);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Object object;
                TreePath path;
                if (ClassSelector.this.selectionListener != null && event.getClickCount() == 2 && (path = ClassSelector.this.getSelectionPath()) != null && (object = path.getLastPathComponent()) instanceof ClassSelectorClassNode) {
                    ClassSelectorClassNode node = (ClassSelectorClassNode)object;
                    ClassSelector.this.selectionListener.onSelectClass(node.getObfEntry());
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TreePath[] paths = ClassSelector.this.getSelectionPaths();
                if (paths != null) {
                    ClassSelectorClassNode node;
                    Object object;
                    if (e.isControlDown() && e.getKeyCode() == 79) {
                        for (TreePath path : paths) {
                            object = path.getLastPathComponent();
                            if (!(object instanceof ClassSelectorClassNode)) continue;
                            node = (ClassSelectorClassNode)object;
                            gui.toggleMappingFromEntry(node.getObfEntry());
                        }
                    }
                    if (ClassSelector.this.selectionListener != null && e.getKeyCode() == 10) {
                        for (TreePath path : paths) {
                            object = path.getLastPathComponent();
                            if (!(object instanceof ClassSelectorClassNode)) continue;
                            node = (ClassSelectorClassNode)object;
                            ClassSelector.this.selectionListener.onSelectClass(node.getObfEntry());
                        }
                    }
                }
            }
        });
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer(){
            {
                this.setLeafIcon(GuiUtil.CLASS_ICON);
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (leaf && value instanceof ClassSelectorClassNode) {
                    this.setIcon(GuiUtil.getClassIcon(gui, ((ClassSelectorClassNode)value).getObfEntry()));
                }
                return this;
            }
        };
        this.setCellRenderer(renderer);
        ClassSelector tree = this;
        final DefaultTreeCellEditor editor = new DefaultTreeCellEditor(tree, renderer){

            @Override
            public boolean isCellEditable(EventObject event) {
                return isRenamable && !(event instanceof MouseEvent) && super.isCellEditable(event);
            }
        };
        this.setCellEditor(editor);
        editor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                String data = editor.getCellEditorValue().toString();
                TreePath path = ClassSelector.this.getSelectionPath();
                Object realPath = path.getLastPathComponent();
                if (realPath instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)realPath;
                    if (data != null) {
                        TreeNode parentNode = node.getParent();
                        if (parentNode == null) {
                            return;
                        }
                        boolean allowEdit = true;
                        for (int i = 0; i < parentNode.getChildCount(); ++i) {
                            TreeNode childNode = parentNode.getChildAt(i);
                            if (childNode == null || !childNode.toString().equals(data) || childNode == node) continue;
                            allowEdit = false;
                            break;
                        }
                        if (allowEdit && ClassSelector.this.renameSelectionListener != null) {
                            Object prevData = node.getUserObject();
                            Object objectData = node.getUserObject() instanceof ClassEntry ? new ClassEntry(((ClassEntry)prevData).getPackageName() + "/" + data) : data;
                            gui.validateImmediateAction(vc -> {
                                ClassSelector.this.renameSelectionListener.onSelectionRename((ValidationContext)vc, node.getUserObject(), objectData, node);
                                if (vc.canProceed()) {
                                    node.setUserObject(objectData);
                                } else {
                                    editor.cancelCellEditing();
                                }
                            });
                        } else {
                            editor.cancelCellEditing();
                        }
                    }
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        this.selectionListener = null;
        this.renameSelectionListener = null;
    }

    public void setSelectionListener(ClassSelectionListener val) {
        this.selectionListener = val;
    }

    public void setRenameSelectionListener(RenameSelectionListener renameSelectionListener) {
        this.renameSelectionListener = renameSelectionListener;
    }

    public void setClasses(Collection<ClassEntry> classEntries) {
        List<StateEntry> state = this.getExpansionState();
        if (classEntries == null) {
            this.setModel(null);
            return;
        }
        this.packageManager = new NestedPackages(classEntries, this.comparator, this.controller.project.getMapper());
        this.setModel(new DefaultTreeModel(this.packageManager.getRoot()));
        this.restoreExpansionState(state);
    }

    public ClassEntry getSelectedClass() {
        Object selectedNode;
        if (!this.isSelectionEmpty() && (selectedNode = this.getSelectionPath().getLastPathComponent()) instanceof ClassSelectorClassNode) {
            ClassSelectorClassNode classNode = (ClassSelectorClassNode)selectedNode;
            return classNode.getClassEntry();
        }
        return null;
    }

    public List<StateEntry> getExpansionState() {
        ArrayList<StateEntry> state = new ArrayList<StateEntry>();
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            TreePath path = this.getPathForRow(i);
            if (this.isPathSelected(path)) {
                state.add(new StateEntry(State.SELECTED, path));
            }
            if (!this.isExpanded(path)) continue;
            state.add(new StateEntry(State.EXPANDED, path));
        }
        return state;
    }

    public void restoreExpansionState(List<StateEntry> expansionState) {
        this.clearSelection();
        for (StateEntry entry : expansionState) {
            switch (entry.state.ordinal()) {
                case 1: {
                    this.addSelectionPath(entry.path);
                    break;
                }
                case 0: {
                    this.expandPath(entry.path);
                }
            }
        }
    }

    public void expandPackage(String packageName) {
        if (packageName == null) {
            return;
        }
        this.expandPath(this.packageManager.getPackagePath(packageName));
    }

    public void expandAll() {
        for (DefaultMutableTreeNode packageNode : this.packageManager.getPackageNodes()) {
            this.expandPath(new TreePath(packageNode.getPath()));
        }
    }

    public void collapseAll() {
        ArrayList<DefaultMutableTreeNode> packageNodes = new ArrayList<DefaultMutableTreeNode>(this.packageManager.getPackageNodes());
        packageNodes.sort(Comparator.comparingInt(DefaultMutableTreeNode::getDepth));
        for (DefaultMutableTreeNode packageNode : packageNodes) {
            this.collapsePath(new TreePath(packageNode.getPath()));
        }
    }

    public void setSelectionClass(ClassEntry classEntry) {
        this.expandPackage(classEntry.getPackageName());
        ClassSelectorClassNode node = this.packageManager.getClassNode(classEntry);
        if (node != null) {
            TreePath path = new TreePath(node.getPath());
            this.setSelectionPath(path);
            this.scrollPathToVisible(path);
        }
    }

    public void moveClassIn(ClassEntry classEntry) {
        this.removeEntry(classEntry);
        this.packageManager.addEntry(classEntry);
    }

    public void removeEntry(ClassEntry classEntry) {
        this.packageManager.removeClassNode(classEntry);
    }

    public void reload() {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.reload(this.packageManager.getRoot());
    }

    public static interface ClassSelectionListener {
        public void onSelectClass(ClassEntry var1);
    }

    public static interface RenameSelectionListener {
        public void onSelectionRename(ValidationContext var1, Object var2, Object var3, DefaultMutableTreeNode var4);
    }

    public record StateEntry(State state, TreePath path) {
    }

    public static enum State {
        EXPANDED,
        SELECTED;

    }
}

