/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SimplifyExprentsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ValidationHelper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.MonitorExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectEdge;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectEdgeType;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectNodeType;
import org.jetbrains.java.decompiler.modules.decompiler.flow.FlattenStatementsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.SSAConstructorSparseEx;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.SSAUConstructorSparseEx;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionNode;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionsGraph;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.CodeType;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.collections.FastSparseSetFactory;
import org.jetbrains.java.decompiler.util.collections.SFormsFastMapDirect;

public class StackVarsProcessor {
    private static final StackSimplifyOptions DEFAULT_OPTIONS = new StackSimplifyOptions();

    public static void simplifyStackVars(RootStatement root, StructMethod mt, StructClass cl) {
        StackVarsProcessor.simplifyStackVars(root, mt, cl, DEFAULT_OPTIONS);
    }

    public static void simplifyStackVars(RootStatement root, StructMethod mt, StructClass cl, StackSimplifyOptions options) {
        boolean found;
        HashSet<Integer> setReorderedIfs = new HashSet<Integer>();
        SSAUConstructorSparseEx ssau = null;
        do {
            found = false;
            boolean first = ssau == null;
            SSAConstructorSparseEx ssa = new SSAConstructorSparseEx();
            ssa.splitVariables(root, mt);
            while (SimplifyExprentsHelper.simplifyStackVarsStatement(root, setReorderedIfs, ssa, cl, first)) {
                ValidationHelper.validateStatement(root);
                found = true;
            }
            StackVarsProcessor.setVersionsToNull(root);
            SequenceHelper.condenseSequences(root);
            ValidationHelper.validateStatement(root);
            ssau = new SSAUConstructorSparseEx();
            ssau.splitVariables(root, mt);
            if (first) {
                StackVarsProcessor.setEffectivelyFinalVars(root, ssau, new HashMap<VarVersionPair, VarExprent>());
                ValidationHelper.validateStatement(root);
            }
            if (StackVarsProcessor.iterateStatements(root, ssau, options)) {
                ValidationHelper.validateStatement(root);
                found = true;
            }
            StackVarsProcessor.setVersionsToNull(root);
        } while (found);
        ssau = new SSAUConstructorSparseEx();
        ssau.splitVariables(root, mt);
        ValidationHelper.validateStatement(root);
        StackVarsProcessor.iterateStatements(root, ssau, options);
        StackVarsProcessor.setVersionsToNull(root);
    }

    public static void setVersionsToNull(Statement stat) {
        if (stat.getExprents() == null) {
            for (Object obj : stat.getSequentialObjects()) {
                if (obj instanceof Statement) {
                    StackVarsProcessor.setVersionsToNull((Statement)obj);
                    continue;
                }
                if (!(obj instanceof Exprent)) continue;
                StackVarsProcessor.setExprentVersionsToNull((Exprent)obj);
            }
        } else {
            for (Exprent exprent : stat.getExprents()) {
                StackVarsProcessor.setExprentVersionsToNull(exprent);
            }
        }
    }

    private static void setExprentVersionsToNull(Exprent exprent) {
        List<Exprent> lst = exprent.getAllExprents(true);
        lst.add(exprent);
        for (Exprent expr : lst) {
            if (!(expr instanceof VarExprent)) continue;
            ((VarExprent)expr).setVersion(0);
        }
    }

    private static boolean iterateStatements(RootStatement root, SSAUConstructorSparseEx ssa, StackSimplifyOptions options) {
        FlattenStatementsHelper flatthelper = new FlattenStatementsHelper();
        DirectGraph dgraph = flatthelper.buildDirectGraph(root);
        boolean res = false;
        HashSet<DirectNode> setVisited = new HashSet<DirectNode>();
        LinkedList<DirectNode> stack = new LinkedList<DirectNode>();
        LinkedList stackMaps = new LinkedList();
        stack.add(dgraph.first);
        stackMaps.add(new HashMap());
        int[] ret = new int[]{0, 0};
        while (!stack.isEmpty()) {
            DoStatement loop;
            List<DirectEdge> succs;
            DirectNode nd = (DirectNode)stack.removeFirst();
            Map mapVarValues = (Map)stackMaps.removeFirst();
            if (setVisited.contains(nd)) continue;
            setVisited.add(nd);
            ArrayList<List<Exprent>> lstLists = new ArrayList<List<Exprent>>();
            if (!nd.exprents.isEmpty()) {
                lstLists.add(nd.exprents);
            }
            if ((succs = nd.getSuccessors(DirectEdgeType.REGULAR)).size() == 1) {
                DirectNode ndsucc = succs.get(0).getDestination();
                if (ndsucc.type == DirectNodeType.TAIL && !ndsucc.exprents.isEmpty()) {
                    lstLists.add(succs.get((int)0).getDestination().exprents);
                    nd = ndsucc;
                }
            }
            for (int stackStage = 0; stackStage < 2; ++stackStage) {
                if (!DecompilerContext.getOption("simplify-stack")) {
                    stackStage = 2;
                }
                for (int i = 0; i < lstLists.size(); ++i) {
                    List lst = (List)lstLists.get(i);
                    int index = 0;
                    while (index < lst.size()) {
                        Exprent next = null;
                        if (index == lst.size() - 1) {
                            if (i < lstLists.size() - 1) {
                                next = (Exprent)((List)lstLists.get(i + 1)).get(0);
                            }
                        } else {
                            next = (Exprent)lst.get(index + 1);
                        }
                        boolean simplifyAcrossStack = stackStage == 1;
                        StackVarsProcessor.iterateExprent(lst, index, next, mapVarValues, ssa, simplifyAcrossStack, ret, options);
                        index = ret[0] >= 0 ? ret[0] : ++index;
                        boolean changed = ret[1] == 1;
                        res |= changed;
                        if (!changed) continue;
                        stackStage = 2;
                    }
                }
            }
            for (DirectEdge ndx : succs) {
                stack.add(ndx.getDestination());
                stackMaps.add(new HashMap(mapVarValues));
            }
            if (!nd.exprents.isEmpty() || nd.type != DirectNodeType.INIT && nd.type != DirectNodeType.CONDITION && nd.type != DirectNodeType.INCREMENT) continue;
            nd.exprents.add(null);
            if (!(nd.statement instanceof DoStatement) || (loop = (DoStatement)nd.statement).getLooptype() != DoStatement.Type.FOR || loop.getInitExprent() != null || loop.getIncExprent() != null) continue;
            loop.setLooptype(DoStatement.Type.WHILE);
        }
        return res;
    }

    private static Exprent isReplaceableVar(Exprent exprent, Map<VarVersionPair, Exprent> mapVarValues) {
        Exprent dest = null;
        if (exprent instanceof VarExprent) {
            VarExprent var = (VarExprent)exprent;
            dest = mapVarValues.get(new VarVersionPair(var));
        }
        return dest;
    }

    private static void replaceSingleVar(Exprent parent, VarExprent var, Exprent dest, SSAUConstructorSparseEx ssau) {
        parent.replaceExprent(var, dest);
        dest.addBytecodeOffsets(var.bytecode);
        SFormsFastMapDirect liveMap = ssau.getLiveVarVersionsMap(new VarVersionPair(var));
        Set<VarVersionPair> setVars = StackVarsProcessor.getAllVersions(dest);
        for (VarVersionPair pair : setVars) {
            VarVersionNode node = ssau.getSsuVersions().nodes.getWithKey(pair);
            if (node.live == null) continue;
            for (Map.Entry<Integer, FastSparseSetFactory.FastSparseSet<Integer>> entry : node.live.entryList()) {
                Integer key = entry.getKey();
                if (!liveMap.containsKey(key)) {
                    node.live.remove(key);
                    continue;
                }
                FastSparseSetFactory.FastSparseSet<Integer> set = entry.getValue();
                set.complement(liveMap.get(key));
                if (!set.isEmpty()) continue;
                node.live.remove(key);
            }
        }
    }

    private static void iterateExprent(List<Exprent> lstExprents, int index, Exprent next, Map<VarVersionPair, Exprent> mapVarValues, SSAUConstructorSparseEx ssau, boolean simplifyAcrossStack, int[] ret, StackSimplifyOptions options) {
        Set<VarVersionPair> setNextVars;
        Exprent simplifiedAcrossStack;
        AssignmentExprent as;
        Exprent exprent = lstExprents.get(index);
        int changed = 0;
        Object[] arr = new Object[]{null, false, false};
        for (Exprent expr : exprent.getAllExprents()) {
            boolean isReplaceable;
            do {
                StackVarsProcessor.iterateChildExprent(expr, exprent, next, mapVarValues, ssau, arr, options);
                Exprent retexpr = (Exprent)arr[0];
                changed |= (Boolean)arr[1] != false ? 1 : 0;
                isReplaceable = (Boolean)arr[2];
                if (retexpr == null) continue;
                if (isReplaceable) {
                    StackVarsProcessor.replaceSingleVar(exprent, (VarExprent)expr, retexpr, ssau);
                    expr = retexpr;
                } else {
                    exprent.replaceExprent(expr, retexpr);
                    retexpr.addBytecodeOffsets(expr.bytecode);
                }
                changed = 1;
            } while (isReplaceable);
        }
        VarExprent left = null;
        Exprent right = null;
        if (exprent instanceof AssignmentExprent && ((AssignmentExprent)exprent).getCondType() == null && (as = (AssignmentExprent)exprent).getLeft() instanceof VarExprent) {
            left = (VarExprent)as.getLeft();
            right = as.getRight();
        }
        if (left == null || left.isEffectivelyFinal()) {
            StackVarsProcessor.setRet(ret, -1, changed);
            return;
        }
        VarVersionPair leftVar = new VarVersionPair(left);
        ArrayList usedVers = new ArrayList();
        boolean notdom = StackVarsProcessor.getUsedVersions(ssau, leftVar, usedVers);
        if (!notdom && usedVers.isEmpty()) {
            if (left.isStack() && (right instanceof InvocationExprent || right instanceof AssignmentExprent || right instanceof NewExprent)) {
                if (right instanceof NewExprent) {
                    NewExprent nexpr = (NewExprent)right;
                    if (nexpr.getNewType().arrayDim > 0 || nexpr.getNewType().type != CodeType.OBJECT) {
                        StackVarsProcessor.setRet(ret, -1, changed);
                        return;
                    }
                }
                lstExprents.set(index, right);
                StackVarsProcessor.setRet(ret, index + 1, 1);
                return;
            }
            if (right instanceof VarExprent) {
                lstExprents.remove(index);
                StackVarsProcessor.setRet(ret, index, 1);
                return;
            }
            if (left.isStack() && right instanceof FunctionExprent) {
                FunctionExprent func = (FunctionExprent)right;
                if (func.getFuncType().isPostfixPPMM()) {
                    lstExprents.set(index, right);
                    StackVarsProcessor.setRet(ret, index, 1);
                    return;
                }
                if (func.getFuncType() == FunctionExprent.FunctionType.CAST && !(func.getLstOperands().get(0) instanceof InvocationExprent)) {
                    lstExprents.remove(index);
                    StackVarsProcessor.setRet(ret, index, 1);
                    return;
                }
                StackVarsProcessor.setRet(ret, -1, changed);
                return;
            }
            if (left.isStack() && right instanceof FieldExprent) {
                lstExprents.remove(index);
                StackVarsProcessor.setRet(ret, index, 1);
                return;
            }
            StackVarsProcessor.setRet(ret, -1, changed);
            return;
        }
        int useflags = right.getExprentUse();
        if (!(left.isStack() || options.inlineRegularVars || right instanceof VarExprent && !((VarExprent)right).isStack())) {
            StackVarsProcessor.setRet(ret, -1, changed);
            return;
        }
        if ((useflags & 1) == 0 && (notdom || usedVers.size() > 1)) {
            StackVarsProcessor.setRet(ret, -1, changed);
            return;
        }
        Map<Integer, Set<VarVersionPair>> mapVars = StackVarsProcessor.getAllVarVersions(leftVar, right, ssau);
        boolean isSelfReference = mapVars.containsKey(leftVar.var);
        if (isSelfReference && notdom) {
            StackVarsProcessor.setRet(ret, -1, changed);
            return;
        }
        if (simplifyAcrossStack && (simplifiedAcrossStack = StackVarsProcessor.simplifyAcrossStackExprent(lstExprents, index, next, right, left)) != null) {
            next = simplifiedAcrossStack;
        }
        Set<VarVersionPair> set = setNextVars = next == null ? null : StackVarsProcessor.getAllVersions(next);
        if (!(right instanceof ConstExprent) && !(right instanceof VarExprent) && setNextVars != null && mapVars.containsKey(leftVar.var)) {
            for (VarVersionNode usedvar : usedVers) {
                if (setNextVars.contains(new VarVersionPair(usedvar.var, usedvar.version))) continue;
                StackVarsProcessor.setRet(ret, -1, changed);
                return;
            }
        }
        mapVars.remove(leftVar.var);
        boolean vernotreplaced = false;
        boolean verreplaced = false;
        HashSet<VarVersionPair> setTempUsedVers = new HashSet<VarVersionPair>();
        for (VarVersionNode usedvar : usedVers) {
            VarVersionPair usedver = new VarVersionPair(usedvar.var, usedvar.version);
            if (StackVarsProcessor.isVersionToBeReplaced(usedver, mapVars, ssau, leftVar) && (right instanceof ConstExprent || right instanceof VarExprent || right instanceof FieldExprent || setNextVars == null || setNextVars.contains(usedver))) {
                setTempUsedVers.add(usedver);
                verreplaced = true;
                continue;
            }
            vernotreplaced = true;
        }
        if (isSelfReference && vernotreplaced) {
            StackVarsProcessor.setRet(ret, -1, changed);
            return;
        }
        for (VarVersionPair usedver : setTempUsedVers) {
            Exprent copy = right.copy();
            if (right instanceof FieldExprent && ssau.getMapFieldVars().containsKey(right.id)) {
                ssau.getMapFieldVars().put(copy.id, ssau.getMapFieldVars().get(right.id));
            }
            mapVarValues.put(usedver, copy);
        }
        if (!notdom && !vernotreplaced) {
            lstExprents.remove(index);
            StackVarsProcessor.setRet(ret, index, 1);
            return;
        }
        if (verreplaced) {
            StackVarsProcessor.setRet(ret, index + 1, changed);
            return;
        }
        StackVarsProcessor.setRet(ret, -1, changed);
    }

    private static Exprent simplifyAcrossStackExprent(List<Exprent> exprents, int index, Exprent next, Exprent right, VarExprent left) {
        Exprent ret;
        block2: {
            List<Exprent> allNextRight;
            List<Exprent> allRight;
            block3: {
                ret = null;
                if (!(next instanceof AssignmentExprent) || index >= exprents.size() - 2) break block2;
                Exprent nextRight = ((AssignmentExprent)next).getRight();
                allRight = right.getAllExprents(true);
                allNextRight = nextRight.getAllExprents(true);
                if (allRight.size() != allNextRight.size() || allRight.isEmpty()) break block3;
                boolean ok = StackVarsProcessor.areTreesEqual(left, allRight, allNextRight);
                if (!ok) break block2;
                ret = exprents.get(index + 2);
                break block2;
            }
            if (allNextRight.size() > allRight.size()) {
                for (Exprent exprent : allNextRight) {
                    boolean ok;
                    List<Exprent> subtree = exprent.getAllExprents(true);
                    if (allRight.size() != subtree.size() || allRight.isEmpty() || !(ok = StackVarsProcessor.areTreesEqual(left, allRight, subtree))) continue;
                    ret = exprents.get(index + 2);
                    break;
                }
            }
        }
        return ret;
    }

    private static void setRet(int[] ret, int a, int b) {
        ret[0] = a;
        ret[1] = b;
    }

    private static boolean areTreesEqual(VarExprent left, List<Exprent> treeA, List<Exprent> treeB) {
        boolean ok = true;
        for (int i = 0; i < treeA.size(); ++i) {
            Exprent a = treeA.get(i);
            Exprent b = treeB.get(i);
            if (a.type != b.type) {
                ok = false;
                break;
            }
            if (a instanceof VarExprent && b instanceof VarExprent) {
                VarExprent va = (VarExprent)a;
                VarExprent vb = (VarExprent)b;
                if (va.getIndex() != vb.getIndex()) {
                    ok = false;
                    break;
                }
                if (vb.getIndex() == left.getIndex()) {
                    ok = false;
                    break;
                }
            }
            if (a instanceof FieldExprent && b instanceof FieldExprent) {
                FieldExprent fa = (FieldExprent)a;
                FieldExprent fb = (FieldExprent)b;
                if (!(InterpreterUtil.equalObjects(fa.getName(), fb.getName()) && InterpreterUtil.equalObjects(fa.getClassname(), fb.getClassname()) && InterpreterUtil.equalObjects(fa.isStatic(), fb.isStatic()) && InterpreterUtil.equalObjects(fa.getDescriptor(), fb.getDescriptor()))) {
                    ok = false;
                    break;
                }
            }
            if (!(a instanceof ConstExprent) || !(b instanceof ConstExprent) || a.equals(b)) continue;
            ok = false;
            break;
        }
        return ok;
    }

    private static Set<VarVersionPair> getAllVersions(Exprent exprent) {
        HashSet<VarVersionPair> res = new HashSet<VarVersionPair>();
        List<Exprent> exprents = exprent.getAllExprents(true);
        exprents.add(exprent);
        for (Exprent expr : exprents) {
            if (!(expr instanceof VarExprent)) continue;
            VarExprent var = (VarExprent)expr;
            res.add(new VarVersionPair(var));
        }
        return res;
    }

    private static void iterateChildExprent(Exprent exprent, Exprent parent, Exprent next, Map<VarVersionPair, Exprent> mapVarValues, SSAUConstructorSparseEx ssau, Object[] ret, StackSimplifyOptions options) {
        MonitorExprent monexpr;
        AssignmentExprent as;
        boolean changed = false;
        Object[] arr = new Object[]{null, false, false};
        for (Exprent expr : exprent.getAllExprents()) {
            boolean isReplaceable;
            do {
                StackVarsProcessor.iterateChildExprent(expr, parent, next, mapVarValues, ssau, arr, options);
                Exprent retexpr = (Exprent)arr[0];
                changed |= ((Boolean)arr[1]).booleanValue();
                isReplaceable = (Boolean)arr[2];
                if (retexpr == null) continue;
                if (isReplaceable) {
                    StackVarsProcessor.replaceSingleVar(exprent, (VarExprent)expr, retexpr, ssau);
                    expr = retexpr;
                } else {
                    exprent.replaceExprent(expr, retexpr);
                    retexpr.addBytecodeOffsets(expr.bytecode);
                }
                changed = true;
            } while (isReplaceable);
        }
        Exprent dest = StackVarsProcessor.isReplaceableVar(exprent, mapVarValues);
        if (dest != null) {
            StackVarsProcessor.setRet(ret, dest, true, true);
            return;
        }
        VarExprent left = null;
        Exprent right = null;
        if (exprent instanceof AssignmentExprent && (as = (AssignmentExprent)exprent).getCondType() == null && as.getLeft() instanceof VarExprent) {
            left = (VarExprent)as.getLeft();
            right = as.getRight();
        }
        if (left == null || left.isEffectivelyFinal()) {
            StackVarsProcessor.setRet(ret, null, changed, false);
            return;
        }
        boolean isHeadSynchronized = false;
        if (next == null && parent instanceof MonitorExprent && (monexpr = (MonitorExprent)parent).getMonType() == MonitorExprent.Type.ENTER && exprent.equals(monexpr.getValue())) {
            isHeadSynchronized = true;
        }
        if (!(left.isStack() || options.inlineRegularVars || isHeadSynchronized)) {
            StackVarsProcessor.setRet(ret, null, changed, false);
            return;
        }
        VarVersionPair leftVar = new VarVersionPair(left);
        ArrayList usedVers = new ArrayList();
        boolean notdom = StackVarsProcessor.getUsedVersions(ssau, leftVar, usedVers);
        if (!notdom && usedVers.isEmpty()) {
            StackVarsProcessor.setRet(ret, right, changed, false);
            return;
        }
        if (!left.isStack()) {
            StackVarsProcessor.setRet(ret, null, changed, false);
            return;
        }
        int useflags = right.getExprentUse();
        if ((useflags & 3) != 3) {
            StackVarsProcessor.setRet(ret, null, changed, false);
            return;
        }
        Map<Integer, Set<VarVersionPair>> mapVars = StackVarsProcessor.getAllVarVersions(leftVar, right, ssau);
        if (mapVars.containsKey(leftVar.var) && notdom) {
            StackVarsProcessor.setRet(ret, null, changed, false);
            return;
        }
        mapVars.remove(leftVar.var);
        Set<VarVersionPair> setAllowedVars = StackVarsProcessor.getAllVersions(parent);
        if (next != null) {
            setAllowedVars.addAll(StackVarsProcessor.getAllVersions(next));
        }
        boolean vernotreplaced = false;
        HashSet<VarVersionPair> setTempUsedVers = new HashSet<VarVersionPair>();
        for (VarVersionNode usedvar : usedVers) {
            VarVersionPair usedver = new VarVersionPair(usedvar.var, usedvar.version);
            if (StackVarsProcessor.isVersionToBeReplaced(usedver, mapVars, ssau, leftVar) && (right instanceof VarExprent || setAllowedVars.contains(usedver))) {
                setTempUsedVers.add(usedver);
                continue;
            }
            vernotreplaced = true;
        }
        if (!notdom && !vernotreplaced) {
            for (VarVersionPair usedver : setTempUsedVers) {
                Exprent copy = right.copy();
                if (right instanceof FieldExprent && ssau.getMapFieldVars().containsKey(right.id)) {
                    ssau.getMapFieldVars().put(copy.id, ssau.getMapFieldVars().get(right.id));
                }
                mapVarValues.put(usedver, copy);
            }
            StackVarsProcessor.setRet(ret, right, changed, false);
            return;
        }
        StackVarsProcessor.setRet(ret, null, changed, false);
    }

    private static void setRet(Object[] ret, Object a, boolean b, boolean c) {
        ret[0] = a;
        ret[1] = b;
        ret[2] = c;
    }

    private static boolean getUsedVersions(SSAUConstructorSparseEx ssa, VarVersionPair var, List<? super VarVersionNode> res) {
        VarVersionsGraph ssu = ssa.getSsuVersions();
        VarVersionNode node = ssu.nodes.getWithKey(var);
        HashSet<VarVersionNode> setVisited = new HashSet<VarVersionNode>();
        HashSet<VarVersionNode> setNotDoms = new HashSet<VarVersionNode>();
        ArrayDeque<VarVersionNode> stack = new ArrayDeque<VarVersionNode>();
        stack.add(node);
        while (!stack.isEmpty()) {
            VarVersionNode nd = (VarVersionNode)stack.poll();
            setVisited.add(nd);
            if (nd != node) {
                res.add(nd);
            }
            for (VarVersionNode dest : nd.successors) {
                if (setVisited.contains(dest)) continue;
                boolean isDominated = true;
                for (VarVersionNode source : dest.predecessors) {
                    if (setVisited.contains(source)) continue;
                    isDominated = false;
                    break;
                }
                if (isDominated) {
                    stack.add(dest);
                    continue;
                }
                setNotDoms.add(dest);
            }
        }
        setNotDoms.removeAll(setVisited);
        return !setNotDoms.isEmpty();
    }

    private static boolean isVersionToBeReplaced(VarVersionPair usedvar, Map<Integer, Set<VarVersionPair>> mapVars, SSAUConstructorSparseEx ssau, VarVersionPair leftpaar) {
        VarVersionsGraph ssuversions = ssau.getSsuVersions();
        SFormsFastMapDirect mapLiveVars = ssau.getLiveVarVersionsMap(usedvar);
        if (mapLiveVars == null) {
            return false;
        }
        if (!InterpreterUtil.equalObjects(ssau.getMapVersionFirstRange().get(leftpaar), ssau.getMapVersionFirstRange().get(usedvar))) {
            return false;
        }
        for (Map.Entry<Integer, Set<VarVersionPair>> ent : mapVars.entrySet()) {
            FastSparseSetFactory.FastSparseSet<Integer> liveverset = mapLiveVars.get(ent.getKey());
            if (liveverset == null) {
                return false;
            }
            HashSet<VarVersionNode> domset = new HashSet<VarVersionNode>();
            for (VarVersionPair verpaar : ent.getValue()) {
                domset.add(ssuversions.nodes.getWithKey(verpaar));
            }
            boolean isdom = true;
            for (int livever : liveverset) {
                VarVersionNode node = ssuversions.nodes.getWithKey(new VarVersionPair(ent.getKey(), livever));
                if (ssuversions.isDominatorSet(node, domset)) continue;
                isdom = false;
                break;
            }
            if (isdom) continue;
            return false;
        }
        return true;
    }

    private static Map<Integer, Set<VarVersionPair>> getAllVarVersions(VarVersionPair leftvar, Exprent exprent, SSAUConstructorSparseEx ssau) {
        HashMap<Integer, Set<VarVersionPair>> map = new HashMap<Integer, Set<VarVersionPair>>();
        SFormsFastMapDirect mapLiveVars = ssau.getLiveVarVersionsMap(leftvar);
        List<Exprent> lst = exprent.getAllExprents(true);
        lst.add(exprent);
        for (Exprent expr : lst) {
            HashSet<VarVersionPair> verset;
            int varindex;
            if (expr instanceof VarExprent) {
                varindex = ((VarExprent)expr).getIndex();
                if (leftvar.var != varindex) {
                    if (mapLiveVars.containsKey(varindex)) {
                        verset = new HashSet<VarVersionPair>();
                        for (int vers : mapLiveVars.get(varindex)) {
                            verset.add(new VarVersionPair(varindex, vers));
                        }
                        map.put(varindex, verset);
                        continue;
                    }
                    throw new RuntimeException("inconsistent live map!");
                }
                map.put(varindex, null);
                continue;
            }
            if (!(expr instanceof FieldExprent) || !ssau.getMapFieldVars().containsKey(expr.id) || !mapLiveVars.containsKey(varindex = ssau.getMapFieldVars().get(expr.id).intValue())) continue;
            verset = new HashSet();
            for (int vers : mapLiveVars.get(varindex)) {
                verset.add(new VarVersionPair(varindex, vers));
            }
            map.put(varindex, verset);
        }
        return map;
    }

    private static void setEffectivelyFinalVars(Statement stat, SSAUConstructorSparseEx ssau, Map<VarVersionPair, VarExprent> varLookupMap) {
        if (stat.getExprents() != null && !stat.getExprents().isEmpty()) {
            for (int i = 0; i < stat.getExprents().size(); ++i) {
                StackVarsProcessor.setEffectivelyFinalVars(stat, stat.getExprents().get(i), ssau, i, stat.getExprents(), varLookupMap);
            }
        }
        for (Statement st : stat.getStats()) {
            StackVarsProcessor.setEffectivelyFinalVars(st, ssau, varLookupMap);
        }
    }

    private static void setEffectivelyFinalVars(Statement stat, Exprent exprent, SSAUConstructorSparseEx ssau, int index, List<Exprent> list, Map<VarVersionPair, VarExprent> varLookupMap) {
        ClassesProcessor.ClassNode node;
        NewExprent newExpr;
        if (exprent instanceof AssignmentExprent) {
            AssignmentExprent assign = (AssignmentExprent)exprent;
            if (assign.getLeft() instanceof VarExprent) {
                VarExprent var = (VarExprent)assign.getLeft();
                varLookupMap.put(var.getVarVersionPair(), var);
            }
        } else if (exprent instanceof NewExprent && (newExpr = (NewExprent)exprent).isAnonymous() && (node = DecompilerContext.getClassProcessor().getMapRootClasses().get(newExpr.getNewType().value)) != null) {
            if (!newExpr.isLambda()) {
                for (StructMethod mt : node.classStruct.getMethods()) {
                    if (!mt.getName().equals("<init>")) continue;
                    List<VarType> paramTypes = Arrays.asList(MethodDescriptor.parseDescriptor((String)mt.getDescriptor()).params);
                    for (int i = Math.max(0, index - paramTypes.size()); i < index; ++i) {
                        VarExprent leftVar;
                        Exprent left;
                        Exprent temp = list.get(i);
                        if (!(temp instanceof AssignmentExprent) || !((left = ((AssignmentExprent)temp).getLeft()) instanceof VarExprent) || (leftVar = (VarExprent)left).getLVT() == null || !paramTypes.contains(leftVar.getLVT().getVarType())) continue;
                        leftVar.setEffectivelyFinal(true);
                    }
                    break;
                }
            } else if (!newExpr.isMethodReference()) {
                MethodDescriptor mdLambda = MethodDescriptor.parseDescriptor(node.lambdaInformation.method_descriptor);
                MethodDescriptor mdContent = MethodDescriptor.parseDescriptor(node.lambdaInformation.content_method_descriptor);
                int paramOffset = node.lambdaInformation.is_content_method_static ? 0 : 1;
                int varsCount = mdContent.params.length - mdLambda.params.length;
                for (int i = 0; i < varsCount; ++i) {
                    VarExprent paramVar;
                    VarVersionPair vvp;
                    VarVersionNode vvnode;
                    Exprent param = newExpr.getConstructor().getLstParameters().get(paramOffset + i);
                    if (!(param instanceof VarExprent) || (vvnode = ssau.getSsuVersions().nodes.getWithKey(vvp = (paramVar = (VarExprent)param).getVarVersionPair())) == null) continue;
                    while (true) {
                        VarVersionNode next = null;
                        if (vvnode.var >= 10000) {
                            vvnode = vvnode.predecessors.iterator().next();
                            VarVersionPair nextVVP = ssau.getVarAssignmentMap().get(new VarVersionPair(vvnode.var, vvnode.version));
                            next = ssau.getSsuVersions().nodes.getWithKey(nextVVP);
                            if (nextVVP != null && nextVVP.var < 0) {
                                vvp = nextVVP;
                                break;
                            }
                        } else {
                            int j = i;
                            int varIndex = vvnode.var;
                            int varVersion = vvnode.version;
                            List<VarVersionNode> roots = StackVarsProcessor.getRoots(vvnode);
                            List allRoots = ssau.getSsuVersions().nodes.stream().distinct().filter(n -> n.var == varIndex && n.predecessors.isEmpty()).filter(n -> {
                                if (n.lvt != null) {
                                    return mdContent.params[j].equals(new VarType(n.lvt.getDescriptor()));
                                }
                                return n.version > varVersion;
                            }).collect(Collectors.toList());
                            if (roots.size() >= allRoots.size()) {
                                if (roots.size() == 1) {
                                    vvnode = roots.get(0);
                                    vvp = new VarVersionPair(vvnode.var, vvnode.version);
                                    VarVersionPair nextVVP = ssau.getVarAssignmentMap().get(vvp);
                                    next = ssau.getSsuVersions().nodes.getWithKey(nextVVP);
                                    if (nextVVP != null && nextVVP.var < 0) {
                                        vvp = nextVVP;
                                        break;
                                    }
                                } else if (roots.size() == 2) {
                                    VarVersionNode first = roots.get(0);
                                    VarVersionNode second = roots.get(1);
                                    if (first.lvt != null && second.lvt != null && first.lvt.getVersion().equals(second.lvt.getVersion())) {
                                        vvp = first.lvt.getVersion();
                                        break;
                                    }
                                }
                            }
                        }
                        if (next == null) break;
                        vvnode = next;
                    }
                    VarExprent var = varLookupMap.get(vvp);
                    if (var == null) continue;
                    var.setEffectivelyFinal(true);
                }
            }
        }
        for (Exprent ex : exprent.getAllExprents()) {
            StackVarsProcessor.setEffectivelyFinalVars(stat, ex, ssau, index, list, varLookupMap);
        }
    }

    private static List<VarVersionNode> getRoots(VarVersionNode vvnode) {
        ArrayList<VarVersionNode> ret = new ArrayList<VarVersionNode>();
        HashSet<VarVersionNode> visited = new HashSet<VarVersionNode>();
        LinkedList<VarVersionNode> queue = new LinkedList<VarVersionNode>();
        queue.add(vvnode);
        visited.add(vvnode);
        while (!queue.isEmpty()) {
            VarVersionNode next = (VarVersionNode)queue.removeFirst();
            if (next.predecessors.isEmpty()) {
                ret.add(next);
                continue;
            }
            next.predecessors.forEach(source -> {
                if (visited.add((VarVersionNode)source)) {
                    queue.add((VarVersionNode)source);
                }
            });
        }
        return ret;
    }

    public static class StackSimplifyOptions {
        private boolean inlineRegularVars = false;

        public StackSimplifyOptions inlineRegularVars() {
            this.inlineRegularVars = true;
            return this;
        }
    }
}

