/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.classprovider;

import cuchaz.enigma.classprovider.ClassProvider;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;

public class CachingClassProvider
implements ClassProvider {
    private static final long EXPIRE_AFTER = 60000L;
    private static final long MAX_SIZE = 128L;
    private final ClassProvider classProvider;
    private long lastPruneTime = 0L;
    private final ConcurrentHashMap<String, CacheEntry> cache = new ConcurrentHashMap();

    public CachingClassProvider(ClassProvider classProvider) {
        this.classProvider = classProvider;
    }

    @Override
    public Collection<String> getClassNames() {
        return this.classProvider.getClassNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ClassNode get(String name) {
        ConcurrentHashMap<String, CacheEntry> concurrentHashMap;
        long time = System.currentTimeMillis();
        boolean prune = false;
        if (this.lastPruneTime + 120000L < time) {
            concurrentHashMap = this.cache;
            synchronized (concurrentHashMap) {
                if (this.lastPruneTime + 120000L < time) {
                    this.lastPruneTime = time;
                    prune = true;
                }
            }
        }
        if (prune) {
            this.cache.values().removeIf(value -> value.addTime + 60000L < time);
        }
        if ((long)this.cache.size() > 128L) {
            concurrentHashMap = this.cache;
            synchronized (concurrentHashMap) {
                if ((long)this.cache.size() > 128L) {
                    Iterator<Map.Entry<String, CacheEntry>> iterator = this.cache.entrySet().iterator();
                    iterator.next();
                    iterator.remove();
                }
            }
        }
        CacheEntry entry = this.cache.computeIfAbsent(name, key -> new CacheEntry(time, this.classProvider.get((String)key)));
        entry.addTime = time;
        return entry.classNode;
    }

    private static final class CacheEntry {
        private long addTime;
        @Nullable
        private final ClassNode classNode;

        private CacheEntry(long addTime, @Nullable ClassNode classNode) {
            this.addTime = addTime;
            this.classNode = classNode;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof CacheEntry)) return false;
            CacheEntry ce = (CacheEntry)obj;
            if (!Objects.equals(this.classNode, ce.classNode)) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.addTime, this.classNode);
        }
    }
}

