/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.representation.entry;

import cuchaz.enigma.api.view.entry.LocalVariableDefEntryView;
import cuchaz.enigma.source.RenamableTokenType;
import cuchaz.enigma.translation.TranslateResult;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.LocalVariableEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class LocalVariableDefEntry
extends LocalVariableEntry
implements LocalVariableDefEntryView {
    protected final TypeDescriptor desc;

    public LocalVariableDefEntry(MethodEntry ownerEntry, int index, String name, boolean parameter, TypeDescriptor desc, String javadoc) {
        super(ownerEntry, index, name, parameter, javadoc);
        this.desc = Objects.requireNonNull(desc, "Variable desc cannot be null");
    }

    public TypeDescriptor getDesc() {
        return this.desc;
    }

    @Override
    public String getDescriptor() {
        return this.desc.toString();
    }

    @Override
    protected TranslateResult<LocalVariableEntry> extendedTranslate(Translator translator, @NotNull EntryMapping mapping) {
        TypeDescriptor translatedDesc = translator.translate(this.desc);
        String translatedName = mapping.targetName() != null ? mapping.targetName() : this.name;
        String javadoc = mapping.javadoc();
        return TranslateResult.of(mapping.targetName() == null ? RenamableTokenType.OBFUSCATED : RenamableTokenType.DEOBFUSCATED, new LocalVariableDefEntry((MethodEntry)this.parent, this.index, translatedName, this.parameter, translatedDesc, javadoc));
    }

    @Override
    public LocalVariableDefEntry withName(String name) {
        return new LocalVariableDefEntry((MethodEntry)this.parent, this.index, name, this.parameter, this.desc, this.javadocs);
    }

    @Override
    public LocalVariableDefEntry withParent(MethodEntry entry) {
        return new LocalVariableDefEntry(entry, this.index, this.name, this.parameter, this.desc, this.javadocs);
    }

    @Override
    public String toString() {
        return String.valueOf(this.parent) + "(" + this.index + ":" + this.name + ":" + String.valueOf(this.desc) + ")";
    }
}

