/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.biome.v1;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.impl.biome.modification.BuiltInRegistryKeys;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5483;
import net.minecraft.class_6862;

public final class BiomeSelectors {
    private BiomeSelectors() {
    }

    public static Predicate<BiomeSelectionContext> all() {
        return context -> true;
    }

    public static Predicate<BiomeSelectionContext> vanilla() {
        return context -> context.getBiomeKey().method_29177().method_12836().equals("minecraft") && BuiltInRegistryKeys.isBuiltinBiome(context.getBiomeKey());
    }

    public static Predicate<BiomeSelectionContext> foundInOverworld() {
        return context -> context.canGenerateIn((class_5321<class_5363>)class_5363.field_25412);
    }

    public static Predicate<BiomeSelectionContext> foundInTheNether() {
        return context -> context.canGenerateIn((class_5321<class_5363>)class_5363.field_25413);
    }

    public static Predicate<BiomeSelectionContext> foundInTheEnd() {
        return context -> context.canGenerateIn((class_5321<class_5363>)class_5363.field_25414);
    }

    public static Predicate<BiomeSelectionContext> tag(class_6862<class_1959> tag) {
        return context -> context.hasTag(tag);
    }

    @SafeVarargs
    public static Predicate<BiomeSelectionContext> excludeByKey(class_5321<class_1959> ... keys) {
        return BiomeSelectors.excludeByKey((Collection<class_5321<class_1959>>)ImmutableSet.copyOf((Object[])keys));
    }

    public static Predicate<BiomeSelectionContext> excludeByKey(Collection<class_5321<class_1959>> keys) {
        return context -> !keys.contains(context.getBiomeKey());
    }

    @SafeVarargs
    public static Predicate<BiomeSelectionContext> includeByKey(class_5321<class_1959> ... keys) {
        return BiomeSelectors.includeByKey((Collection<class_5321<class_1959>>)ImmutableSet.copyOf((Object[])keys));
    }

    public static Predicate<BiomeSelectionContext> includeByKey(Collection<class_5321<class_1959>> keys) {
        return context -> keys.contains(context.getBiomeKey());
    }

    public static Predicate<BiomeSelectionContext> spawnsOneOf(class_1299<?> ... entityTypes) {
        return BiomeSelectors.spawnsOneOf(ImmutableSet.copyOf((Object[])entityTypes));
    }

    public static Predicate<BiomeSelectionContext> spawnsOneOf(Set<class_1299<?>> entityTypes) {
        return context -> {
            class_5483 spawnSettings = context.getBiome().method_30966();
            for (class_1311 spawnGroup : class_1311.values()) {
                for (class_5483.class_1964 spawnEntry : spawnSettings.method_31004(spawnGroup).method_34994()) {
                    if (!entityTypes.contains(spawnEntry.field_9389)) continue;
                    return true;
                }
            }
            return false;
        };
    }
}

