/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.biome;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.impl.biome.MultiNoiseSamplerHooks;
import net.minecraft.class_5216;
import net.minecraft.class_5284;
import net.minecraft.class_6544;
import net.minecraft.class_7138;
import net.minecraft.class_7871;

@Mixin(class_7138.class)
public class NoiseConfigMixin {
	@Shadow
	@Final
	private class_6544.class_6552 multiNoiseSampler;

	@Inject(method = "<init>", at = @At("TAIL"))
	private void init(class_5284 chunkGeneratorSettings, class_7871<class_5216.class_5487> arg, long seed, CallbackInfo ci) {
		((MultiNoiseSamplerHooks) (Object) multiNoiseSampler).fabric_setSeed(seed);
	}
}
