/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.biome.modification;

import net.minecraft.class_2922;
import net.minecraft.class_2975;
import net.minecraft.class_3504;
import net.minecraft.class_5312;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import org.jetbrains.annotations.ApiStatus;

/**
 * Utility class for getting the registry keys of built-in worldgen objects and throwing proper exceptions if they
 * are not registered.
 */
@ApiStatus.Internal
public final class BuiltInRegistryKeys {
	private BuiltInRegistryKeys() {
	}

	public static class_5321<class_3504<?>> get(class_3504<?> configuredSurfaceBuilder) {
		return class_5458.field_25927.method_29113(configuredSurfaceBuilder)
				.orElseThrow(() -> new IllegalArgumentException("Given surface builder is not built-in: " + configuredSurfaceBuilder));
	}

	public static class_5321<class_5312<?, ?>> get(class_5312<?, ?> configuredStructure) {
		return class_5458.field_25930.method_29113(configuredStructure)
				.orElseThrow(() -> new IllegalArgumentException("Given configured structure is not built-in: " + configuredStructure));
	}

	public static class_5321<class_2975<?, ?>> get(class_2975<?, ?> configuredFeature) {
		return class_5458.field_25929.method_29113(configuredFeature)
				.orElseThrow(() -> new IllegalArgumentException("Given configured feature is not built-in: " + configuredFeature));
	}

	public static class_5321<class_2922<?>> get(class_2922<?> configuredCarver) {
		return class_5458.field_25928.method_29113(configuredCarver)
				.orElseThrow(() -> new IllegalArgumentException("Given configured carver is not built-in: " + configuredCarver));
	}
}
