/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.biome.modification;

import net.minecraft.class_1959;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.gen.Accessor;

@Mixin(class_1959.class_5482.class)
public interface BiomeWeatherAccessor {
	@Accessor
	class_1959.class_1963 getPrecipitation();

	@Accessor
	@Mutable
	void setPrecipitation(class_1959.class_1963 precipitation);

	@Accessor
	float getTemperature();

	@Accessor
	@Mutable
	void setTemperature(float temperature);

	@Accessor
	class_1959.class_5484 getTemperatureModifier();

	@Accessor
	@Mutable
	void setTemperatureModifier(class_1959.class_5484 temperatureModifier);

	@Accessor
	float getDownfall();

	@Accessor
	@Mutable
	void setDownfall(float downfall);
}
