/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.biome.modification;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2893;
import net.minecraft.class_2922;
import net.minecraft.class_2975;
import net.minecraft.class_3504;
import net.minecraft.class_5312;
import net.minecraft.class_5485;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.gen.Accessor;

@Mixin(class_5485.class)
public interface GenerationSettingsAccessor {
	@Accessor("surfaceBuilder")
	Supplier<class_3504<?>> fabric_getSurfaceBuilder();

	@Accessor("carvers")
	Map<class_2893.class_2894, List<Supplier<class_2922<?>>>> fabric_getCarvers();

	@Accessor("features")
	List<List<Supplier<class_2975<?, ?>>>> fabric_getFeatures();

	@Accessor("structureFeatures")
	List<Supplier<class_5312<?, ?>>> fabric_getStructureFeatures();

	@Accessor("flowerFeatures")
	List<class_2975<?, ?>> fabric_getFlowerFeatures();

	@Accessor("surfaceBuilder")
	@Mutable
	void fabric_setSurfaceBuilder(Supplier<class_3504<?>> value);

	@Accessor("carvers")
	@Mutable
	void fabric_setCarvers(Map<class_2893.class_2894, List<Supplier<class_2922<?>>>> value);

	@Accessor("features")
	@Mutable
	void fabric_setFeatures(List<List<Supplier<class_2975<?, ?>>>> value);

	@Accessor("structureFeatures")
	@Mutable
	void fabric_setStructureFeatures(List<Supplier<class_5312<?, ?>>> value);

	@Accessor("flowerFeatures")
	@Mutable
	void fabric_setFlowerFeatures(List<class_2975<?, ?>> value);
}
