/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.biome.modification;

import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_5483;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.gen.Accessor;

@Mixin(class_5483.class)
public interface SpawnSettingsAccessor {
	@Accessor("creatureSpawnProbability")
	@Mutable
	void fabric_setCreatureSpawnProbability(float probability);

	@Accessor("spawners")
	Map<class_1311, List<class_5483.class_1964>> fabric_getSpawners();

	@Accessor("spawners")
	@Mutable
	void fabric_setSpawners(Map<class_1311, List<class_5483.class_1964>> spawners);

	@Accessor("spawnCosts")
	Map<class_1299<?>, class_5483.class_5265> fabric_getSpawnCosts();

	@Accessor("spawnCosts")
	@Mutable
	void fabric_setSpawnCosts(Map<class_1299<?>, class_5483.class_5265> spawnCosts);

	@Accessor("playerSpawnFriendly")
	@Mutable
	void fabric_setPlayerSpawnFriendly(boolean playerSpawnFriendly);
}
