/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.biome.v1;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.NetherBiomes;
import net.fabricmc.fabric.mixin.biome.VanillaLayeredBiomeSourceAccessor;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_5483;

public final class BiomeSelectors {
    private BiomeSelectors() {
    }

    public static Predicate<BiomeSelectionContext> all() {
        return context -> true;
    }

    public static Predicate<BiomeSelectionContext> builtIn() {
        return context -> class_5458.field_25933.method_10250(context.getBiomeKey().method_29177());
    }

    public static Predicate<BiomeSelectionContext> vanilla() {
        return context -> context.getBiomeKey().method_29177().method_12836().equals("minecraft") && class_5458.field_25933.method_10250(context.getBiomeKey().method_29177());
    }

    public static Predicate<BiomeSelectionContext> foundInOverworld() {
        return context -> {
            class_5321<class_1959> biomeKey = context.getBiomeKey();
            return biomeKey == class_1972.field_9468 || biomeKey == class_1972.field_9440 || VanillaLayeredBiomeSourceAccessor.getBIOMES().contains(biomeKey);
        };
    }

    public static Predicate<BiomeSelectionContext> foundInTheNether() {
        return context -> NetherBiomes.canGenerateInNether(context.getBiomeKey());
    }

    public static Predicate<BiomeSelectionContext> foundInTheEnd() {
        return context -> context.getBiome().method_8688() == class_1959.class_1961.field_9360;
    }

    @SafeVarargs
    public static Predicate<BiomeSelectionContext> excludeByKey(class_5321<class_1959> ... keys) {
        return BiomeSelectors.excludeByKey((Collection<class_5321<class_1959>>)ImmutableSet.copyOf((Object[])keys));
    }

    public static Predicate<BiomeSelectionContext> excludeByKey(Collection<class_5321<class_1959>> keys) {
        return context -> !keys.contains(context.getBiomeKey());
    }

    @SafeVarargs
    public static Predicate<BiomeSelectionContext> includeByKey(class_5321<class_1959> ... keys) {
        return BiomeSelectors.includeByKey((Collection<class_5321<class_1959>>)ImmutableSet.copyOf((Object[])keys));
    }

    public static Predicate<BiomeSelectionContext> includeByKey(Collection<class_5321<class_1959>> keys) {
        return context -> keys.contains(context.getBiomeKey());
    }

    public static Predicate<BiomeSelectionContext> spawnsOneOf(class_1299<?> ... entityTypes) {
        return BiomeSelectors.spawnsOneOf(ImmutableSet.copyOf((Object[])entityTypes));
    }

    public static Predicate<BiomeSelectionContext> spawnsOneOf(Set<class_1299<?>> entityTypes) {
        return context -> {
            class_5483 spawnSettings = context.getBiome().method_30966();
            for (class_1311 spawnGroup : class_1311.values()) {
                for (class_5483.class_1964 spawnEntry : spawnSettings.method_31004(spawnGroup)) {
                    if (!entityTypes.contains(spawnEntry.field_9389)) continue;
                    return true;
                }
            }
            return false;
        };
    }

    public static Predicate<BiomeSelectionContext> categories(class_1959.class_1961 ... categories) {
        EnumSet<class_1959.class_1961> categorySet = EnumSet.noneOf(class_1959.class_1961.class);
        Collections.addAll(categorySet, categories);
        return context -> categorySet.contains(context.getBiome().method_8688());
    }
}

