/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.biome;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.biome.v1.OverworldClimate;
import net.fabricmc.fabric.impl.biome.InternalBiomeUtils;
import net.fabricmc.fabric.impl.biome.VariantTransformer;
import net.fabricmc.fabric.impl.biome.WeightedBiomePicker;
import net.fabricmc.fabric.mixin.biome.VanillaLayeredBiomeSourceAccessor;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_3645;
import net.minecraft.class_4766;
import net.minecraft.class_5321;
import net.minecraft.class_5458;

public final class InternalBiomeData {
    private static final EnumMap<OverworldClimate, WeightedBiomePicker> OVERWORLD_MODDED_CONTINENTAL_BIOME_PICKERS = new EnumMap(OverworldClimate.class);
    private static final Map<class_5321<class_1959>, WeightedBiomePicker> OVERWORLD_HILLS_MAP = new IdentityHashMap<class_5321<class_1959>, WeightedBiomePicker>();
    private static final Map<class_5321<class_1959>, WeightedBiomePicker> OVERWORLD_SHORE_MAP = new IdentityHashMap<class_5321<class_1959>, WeightedBiomePicker>();
    private static final Map<class_5321<class_1959>, WeightedBiomePicker> OVERWORLD_EDGE_MAP = new IdentityHashMap<class_5321<class_1959>, WeightedBiomePicker>();
    private static final Map<class_5321<class_1959>, VariantTransformer> OVERWORLD_VARIANT_TRANSFORMERS = new IdentityHashMap<class_5321<class_1959>, VariantTransformer>();
    private static final Map<class_5321<class_1959>, class_5321<class_1959>> OVERWORLD_RIVER_MAP = new IdentityHashMap<class_5321<class_1959>, class_5321<class_1959>>();
    private static final Set<class_5321<class_1959>> NETHER_BIOMES = new HashSet<class_5321<class_1959>>();
    private static final Map<class_5321<class_1959>, class_1959.class_4762> NETHER_BIOME_NOISE_POINTS = new HashMap<class_5321<class_1959>, class_1959.class_4762>();
    private static final Map<class_5321<class_1959>, WeightedBiomePicker> END_BIOMES_MAP = new IdentityHashMap<class_5321<class_1959>, WeightedBiomePicker>();
    private static final Map<class_5321<class_1959>, WeightedBiomePicker> END_MIDLANDS_MAP = new IdentityHashMap<class_5321<class_1959>, WeightedBiomePicker>();
    private static final Map<class_5321<class_1959>, WeightedBiomePicker> END_BARRENS_MAP = new IdentityHashMap<class_5321<class_1959>, WeightedBiomePicker>();

    private InternalBiomeData() {
    }

    public static void addOverworldContinentalBiome(OverworldClimate climate, class_5321<class_1959> biome, double weight) {
        Preconditions.checkArgument((climate != null ? 1 : 0) != 0, (Object)"Climate is null");
        Preconditions.checkArgument((biome != null ? 1 : 0) != 0, (Object)"Biome is null");
        Preconditions.checkArgument((!Double.isNaN(weight) ? 1 : 0) != 0, (Object)"Weight is NaN");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (%s)", (Object)weight);
        InternalBiomeUtils.ensureIdMapping(biome);
        OVERWORLD_MODDED_CONTINENTAL_BIOME_PICKERS.computeIfAbsent(climate, k -> new WeightedBiomePicker()).addBiome(biome, weight);
        InternalBiomeData.injectOverworldBiome(biome);
    }

    public static void addOverworldHillsBiome(class_5321<class_1959> primary, class_5321<class_1959> hills, double weight) {
        Preconditions.checkArgument((primary != null ? 1 : 0) != 0, (Object)"Primary biome is null");
        Preconditions.checkArgument((hills != null ? 1 : 0) != 0, (Object)"Hills biome is null");
        Preconditions.checkArgument((!Double.isNaN(weight) ? 1 : 0) != 0, (Object)"Weight is NaN");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (%s)", (Object)weight);
        InternalBiomeUtils.ensureIdMapping(primary);
        InternalBiomeUtils.ensureIdMapping(hills);
        OVERWORLD_HILLS_MAP.computeIfAbsent(primary, biome -> DefaultHillsData.injectDefaultHills(primary, new WeightedBiomePicker())).addBiome(hills, weight);
        InternalBiomeData.injectOverworldBiome(hills);
    }

    public static void addOverworldShoreBiome(class_5321<class_1959> primary, class_5321<class_1959> shore, double weight) {
        Preconditions.checkArgument((primary != null ? 1 : 0) != 0, (Object)"Primary biome is null");
        Preconditions.checkArgument((shore != null ? 1 : 0) != 0, (Object)"Shore biome is null");
        Preconditions.checkArgument((!Double.isNaN(weight) ? 1 : 0) != 0, (Object)"Weight is NaN");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (%s)", (Object)weight);
        InternalBiomeUtils.ensureIdMapping(primary);
        InternalBiomeUtils.ensureIdMapping(shore);
        OVERWORLD_SHORE_MAP.computeIfAbsent(primary, biome -> new WeightedBiomePicker()).addBiome(shore, weight);
        InternalBiomeData.injectOverworldBiome(shore);
    }

    public static void addOverworldEdgeBiome(class_5321<class_1959> primary, class_5321<class_1959> edge, double weight) {
        Preconditions.checkArgument((primary != null ? 1 : 0) != 0, (Object)"Primary biome is null");
        Preconditions.checkArgument((edge != null ? 1 : 0) != 0, (Object)"Edge biome is null");
        Preconditions.checkArgument((!Double.isNaN(weight) ? 1 : 0) != 0, (Object)"Weight is NaN");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (%s)", (Object)weight);
        InternalBiomeUtils.ensureIdMapping(primary);
        InternalBiomeUtils.ensureIdMapping(edge);
        OVERWORLD_EDGE_MAP.computeIfAbsent(primary, biome -> new WeightedBiomePicker()).addBiome(edge, weight);
        InternalBiomeData.injectOverworldBiome(edge);
    }

    public static void addOverworldBiomeReplacement(class_5321<class_1959> replaced, class_5321<class_1959> variant, double chance, OverworldClimate[] climates) {
        Preconditions.checkArgument((replaced != null ? 1 : 0) != 0, (Object)"Replaced biome is null");
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"Variant biome is null");
        Preconditions.checkArgument((chance > 0.0 && chance <= 1.0 ? 1 : 0) != 0, (Object)"Chance is not greater than 0 or less than or equal to 1");
        InternalBiomeUtils.ensureIdMapping(replaced);
        InternalBiomeUtils.ensureIdMapping(variant);
        OVERWORLD_VARIANT_TRANSFORMERS.computeIfAbsent(replaced, biome -> new VariantTransformer()).addBiome(variant, chance, climates);
        InternalBiomeData.injectOverworldBiome(variant);
    }

    public static void setOverworldRiverBiome(class_5321<class_1959> primary, class_5321<class_1959> river) {
        Preconditions.checkArgument((primary != null ? 1 : 0) != 0, (Object)"Primary biome is null");
        InternalBiomeUtils.ensureIdMapping(primary);
        InternalBiomeUtils.ensureIdMapping(river);
        OVERWORLD_RIVER_MAP.put(primary, river);
        if (river != null) {
            InternalBiomeData.injectOverworldBiome(river);
        }
    }

    private static void injectOverworldBiome(class_5321<class_1959> biome) {
        List<class_5321<class_1959>> biomes = VanillaLayeredBiomeSourceAccessor.getBIOMES();
        if (biomes instanceof ImmutableList) {
            biomes = new ArrayList<class_5321<class_1959>>(biomes);
            VanillaLayeredBiomeSourceAccessor.setBIOMES(biomes);
        }
        biomes.add(biome);
    }

    public static void addNetherBiome(class_5321<class_1959> biome, class_1959.class_4762 spawnNoisePoint) {
        Preconditions.checkArgument((biome != null ? 1 : 0) != 0, (Object)"Biome is null");
        Preconditions.checkArgument((spawnNoisePoint != null ? 1 : 0) != 0, (Object)"Biome.MixedNoisePoint is null");
        InternalBiomeUtils.ensureIdMapping(biome);
        NETHER_BIOME_NOISE_POINTS.put(biome, spawnNoisePoint);
        NETHER_BIOMES.clear();
    }

    public static void addEndBiomeReplacement(class_5321<class_1959> replaced, class_5321<class_1959> variant, double weight) {
        Preconditions.checkNotNull(replaced, (Object)"replaced biome is null");
        Preconditions.checkNotNull(variant, (Object)"variant biome is null");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (got %s)", (Object)weight);
        END_BIOMES_MAP.computeIfAbsent(replaced, key -> new WeightedBiomePicker()).addBiome(variant, weight);
    }

    public static void addEndMidlandsReplacement(class_5321<class_1959> highlands, class_5321<class_1959> midlands, double weight) {
        Preconditions.checkNotNull(highlands, (Object)"highlands biome is null");
        Preconditions.checkNotNull(midlands, (Object)"midlands biome is null");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (got %s)", (Object)weight);
        END_MIDLANDS_MAP.computeIfAbsent(highlands, key -> new WeightedBiomePicker()).addBiome(midlands, weight);
    }

    public static void addEndBarrensReplacement(class_5321<class_1959> highlands, class_5321<class_1959> barrens, double weight) {
        Preconditions.checkNotNull(highlands, (Object)"highlands biome is null");
        Preconditions.checkNotNull(barrens, (Object)"midlands biome is null");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (got %s)", (Object)weight);
        END_BARRENS_MAP.computeIfAbsent(highlands, key -> new WeightedBiomePicker()).addBiome(barrens, weight);
    }

    public static Map<class_5321<class_1959>, WeightedBiomePicker> getOverworldHills() {
        return OVERWORLD_HILLS_MAP;
    }

    public static Map<class_5321<class_1959>, WeightedBiomePicker> getOverworldShores() {
        return OVERWORLD_SHORE_MAP;
    }

    public static Map<class_5321<class_1959>, WeightedBiomePicker> getOverworldEdges() {
        return OVERWORLD_EDGE_MAP;
    }

    public static Map<class_5321<class_1959>, class_5321<class_1959>> getOverworldRivers() {
        return OVERWORLD_RIVER_MAP;
    }

    public static EnumMap<OverworldClimate, WeightedBiomePicker> getOverworldModdedContinentalBiomePickers() {
        return OVERWORLD_MODDED_CONTINENTAL_BIOME_PICKERS;
    }

    public static Map<class_5321<class_1959>, VariantTransformer> getOverworldVariantTransformers() {
        return OVERWORLD_VARIANT_TRANSFORMERS;
    }

    public static Map<class_5321<class_1959>, class_1959.class_4762> getNetherBiomeNoisePoints() {
        return NETHER_BIOME_NOISE_POINTS;
    }

    public static boolean canGenerateInNether(class_5321<class_1959> biome) {
        if (NETHER_BIOMES.isEmpty()) {
            class_4766 source = class_4766.class_5305.field_24723.method_28469(class_5458.field_25933, 0L);
            for (class_1959 netherBiome : source.method_28443()) {
                class_5458.field_25933.method_29113((Object)netherBiome).ifPresent(NETHER_BIOMES::add);
            }
        }
        return NETHER_BIOMES.contains(biome);
    }

    public static Map<class_5321<class_1959>, WeightedBiomePicker> getEndBiomesMap() {
        return END_BIOMES_MAP;
    }

    public static Map<class_5321<class_1959>, WeightedBiomePicker> getEndMidlandsMap() {
        return END_MIDLANDS_MAP;
    }

    public static Map<class_5321<class_1959>, WeightedBiomePicker> getEndBarrensMap() {
        return END_BARRENS_MAP;
    }

    static {
        END_BIOMES_MAP.computeIfAbsent((class_5321<class_1959>)class_1972.field_9411, key -> new WeightedBiomePicker()).addBiome((class_5321<class_1959>)class_1972.field_9411, 1.0);
        END_BIOMES_MAP.computeIfAbsent((class_5321<class_1959>)class_1972.field_9442, key -> new WeightedBiomePicker()).addBiome((class_5321<class_1959>)class_1972.field_9442, 1.0);
        END_BIOMES_MAP.computeIfAbsent((class_5321<class_1959>)class_1972.field_9457, key -> new WeightedBiomePicker()).addBiome((class_5321<class_1959>)class_1972.field_9457, 1.0);
        END_MIDLANDS_MAP.computeIfAbsent((class_5321<class_1959>)class_1972.field_9442, key -> new WeightedBiomePicker()).addBiome((class_5321<class_1959>)class_1972.field_9447, 1.0);
        END_BARRENS_MAP.computeIfAbsent((class_5321<class_1959>)class_1972.field_9442, key -> new WeightedBiomePicker()).addBiome((class_5321<class_1959>)class_1972.field_9465, 1.0);
    }

    private static class DefaultHillsData {
        private static final ImmutableMap<class_5321<class_1959>, class_5321<class_1959>> DEFAULT_HILLS;

        private DefaultHillsData() {
        }

        static WeightedBiomePicker injectDefaultHills(class_5321<class_1959> base, WeightedBiomePicker picker) {
            class_5321 defaultHill = (class_5321)DEFAULT_HILLS.get(base);
            if (defaultHill != null) {
                picker.addBiome((class_5321<class_1959>)defaultHill, 1.0);
            } else if (class_3645.method_15844((int)InternalBiomeUtils.getRawId(base), (int)InternalBiomeUtils.getRawId((class_5321<class_1959>)class_1972.field_9410))) {
                picker.addBiome((class_5321<class_1959>)class_1972.field_9415, 1.0);
            } else if (base == class_1972.field_9446 || base == class_1972.field_9439 || base == class_1972.field_9470) {
                picker.addBiome((class_5321<class_1959>)class_1972.field_9451, 1.0);
                picker.addBiome((class_5321<class_1959>)class_1972.field_9409, 1.0);
            } else if (base == class_1972.field_9418) {
                picker.addBiome((class_5321<class_1959>)class_1972.field_9451, 0.25);
                picker.addBiome((class_5321<class_1959>)class_1972.field_9409, 0.25);
            } else if (base == class_1972.field_9451) {
                picker.addBiome((class_5321<class_1959>)class_1972.field_9459, 1.0);
                picker.addBiome((class_5321<class_1959>)class_1972.field_9409, 2.0);
            }
            return picker;
        }

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)class_1972.field_9424, (Object)class_1972.field_9466);
            builder.put((Object)class_1972.field_9409, (Object)class_1972.field_9459);
            builder.put((Object)class_1972.field_9412, (Object)class_1972.field_9421);
            builder.put((Object)class_1972.field_9475, (Object)class_1972.field_9451);
            builder.put((Object)class_1972.field_9420, (Object)class_1972.field_9428);
            builder.put((Object)class_1972.field_9477, (Object)class_1972.field_9429);
            builder.put((Object)class_1972.field_9454, (Object)class_1972.field_9425);
            builder.put((Object)class_1972.field_9452, (Object)class_1972.field_9444);
            builder.put((Object)class_1972.field_9417, (Object)class_1972.field_9432);
            builder.put((Object)class_1972.field_9440, (Object)class_1972.field_9468);
            builder.put((Object)class_1972.field_9423, (Object)class_1972.field_9446);
            builder.put((Object)class_1972.field_9441, (Object)class_1972.field_9439);
            builder.put((Object)class_1972.field_9467, (Object)class_1972.field_9470);
            builder.put((Object)class_1972.field_9435, (Object)class_1972.field_9418);
            builder.put((Object)class_1972.field_9472, (Object)class_1972.field_9460);
            builder.put((Object)class_1972.field_9449, (Object)class_1972.field_9430);
            DEFAULT_HILLS = builder.build();
        }
    }
}

