/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.biome;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntConsumer;
import net.fabricmc.fabric.api.biome.v1.OverworldClimate;
import net.fabricmc.fabric.impl.biome.InternalBiomeData;
import net.fabricmc.fabric.impl.biome.VariantTransformer;
import net.fabricmc.fabric.impl.biome.WeightedBiomeEntry;
import net.fabricmc.fabric.impl.biome.WeightedBiomePicker;
import net.fabricmc.fabric.mixin.biome.AddHillsLayerAccessor;
import net.fabricmc.fabric.mixin.biome.BuiltinBiomesAccessor;
import net.minecraft.class_1959;
import net.minecraft.class_3630;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_5504;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class InternalBiomeUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    private InternalBiomeUtils() {
    }

    public static boolean isEdge(int north, int east, int south, int west, int center) {
        return InternalBiomeUtils.areUnsimilar(center, north) || InternalBiomeUtils.areUnsimilar(center, east) || InternalBiomeUtils.areUnsimilar(center, south) || InternalBiomeUtils.areUnsimilar(center, west);
    }

    private static boolean areUnsimilar(int mainBiomeId, int secondaryBiomeId) {
        if (mainBiomeId == secondaryBiomeId) {
            return false;
        }
        Int2IntMap parentChildMap = AddHillsLayerAccessor.getBaseToVariantMap();
        return parentChildMap.get(mainBiomeId) != secondaryBiomeId && parentChildMap.get(secondaryBiomeId) != mainBiomeId;
    }

    public static boolean neighborsOcean(int north, int east, int south, int west) {
        return InternalBiomeUtils.isOceanBiome(north) || InternalBiomeUtils.isOceanBiome(east) || InternalBiomeUtils.isOceanBiome(south) || InternalBiomeUtils.isOceanBiome(west);
    }

    private static boolean isOceanBiome(int id) {
        class_1959 biome = (class_1959)class_5458.field_25933.method_10200(id);
        return biome != null && biome.method_8688() == class_1959.class_1961.field_9367;
    }

    public static int searchForBiome(double reqWeightSum, int vanillaArrayWeight, List<WeightedBiomeEntry> moddedBiomes) {
        reqWeightSum -= (double)vanillaArrayWeight;
        int low = 0;
        int high = moddedBiomes.size() - 1;
        while (low < high) {
            int mid = high + low >>> 1;
            if (reqWeightSum < moddedBiomes.get(mid).getUpperWeightBound()) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return low;
    }

    public static int transformBiome(class_3630 random, class_5321<class_1959> existing, OverworldClimate climate) {
        Map<class_5321<class_1959>, VariantTransformer> overworldVariantTransformers = InternalBiomeData.getOverworldVariantTransformers();
        VariantTransformer transformer = overworldVariantTransformers.get(existing);
        if (transformer != null) {
            class_5321<class_1959> key = transformer.transformBiome(existing, random, climate);
            return InternalBiomeUtils.getRawId(key);
        }
        return InternalBiomeUtils.getRawId(existing);
    }

    public static void injectBiomesIntoClimate(class_3630 random, int[] vanillaArray, OverworldClimate climate, IntConsumer result) {
        WeightedBiomePicker picker = InternalBiomeData.getOverworldModdedContinentalBiomePickers().get((Object)climate);
        if (picker == null || picker.getCurrentWeightTotal() <= 0.0) {
            return;
        }
        int vanillaArrayWeight = vanillaArray.length;
        double reqWeightSum = (double)random.method_15834(Integer.MAX_VALUE) * ((double)vanillaArray.length + picker.getCurrentWeightTotal()) / 2.147483647E9;
        if (reqWeightSum < (double)vanillaArray.length) {
            result.accept(InternalBiomeUtils.transformBiome(random, (class_5321<class_1959>)class_5504.method_31144((int)vanillaArray[(int)reqWeightSum]), climate));
        } else {
            WeightedBiomeEntry found = picker.search(reqWeightSum - (double)vanillaArrayWeight);
            result.accept(InternalBiomeUtils.transformBiome(random, found.getBiome(), climate));
        }
    }

    public static int getRawId(class_5321<class_1959> key) {
        return class_5458.field_25933.method_10206((Object)((class_1959)class_5458.field_25933.method_31140(key)));
    }

    public static void ensureIdMapping(class_5321<class_1959> biomeKey) {
        int rawId = InternalBiomeUtils.getRawId(biomeKey);
        Int2ObjectMap<class_5321<class_1959>> biomes = BuiltinBiomesAccessor.getBY_RAW_ID();
        if (!biomes.containsKey(rawId)) {
            LOGGER.debug("Automatically creating layer-related raw-id mapping for biome {}", biomeKey);
            biomes.put(rawId, biomeKey);
        }
    }
}

