/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.gametest;

import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.gametest.v1.ClientGameTestContext;
import net.fabricmc.fabric.api.client.gametest.v1.TestWorldBuilder;
import net.fabricmc.fabric.impl.client.gametest.TestInputImpl;
import net.fabricmc.fabric.impl.client.gametest.TestWorldBuilderImpl;
import net.fabricmc.fabric.impl.client.gametest.ThreadingImpl;
import net.fabricmc.fabric.mixin.client.gametest.CyclingButtonWidgetAccessor;
import net.fabricmc.fabric.mixin.client.gametest.GameOptionsAccessor;
import net.fabricmc.fabric.mixin.client.gametest.ScreenAccessor;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1157;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_318;
import net.minecraft.class_339;
import net.minecraft.class_3419;
import net.minecraft.class_4063;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_5676;
import net.minecraft.class_7172;
import net.minecraft.class_8021;
import net.minecraft.class_8144;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableFunction;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ClientGameTestContextImpl
implements ClientGameTestContext {
    private final TestInputImpl input = new TestInputImpl(this);
    private static final Map<String, Object> DEFAULT_GAME_OPTIONS = new HashMap<String, Object>();

    public static void initGameOptions(class_315 options) {
        options.field_1875 = class_1157.field_5653;
        options.method_42528().method_41748((Object)class_4063.field_18162);
        options.field_41785 = false;
        options.method_42503().method_41748((Object)5);
        options.method_45578(class_3419.field_15253).method_41748((Object)0.0);
        ((GameOptionsAccessor)options).invokeAccept(new class_315.class_5823(){

            public int method_33680(String key, int current) {
                DEFAULT_GAME_OPTIONS.put(key, current);
                return current;
            }

            public boolean method_33684(String key, boolean current) {
                DEFAULT_GAME_OPTIONS.put(key, current);
                return current;
            }

            public String method_33683(String key, String current) {
                DEFAULT_GAME_OPTIONS.put(key, current);
                return current;
            }

            public float method_33679(String key, float current) {
                DEFAULT_GAME_OPTIONS.put(key, Float.valueOf(current));
                return current;
            }

            public <T> T method_33681(String key, T current, Function<String, T> decoder, Function<T, String> encoder) {
                DEFAULT_GAME_OPTIONS.put(key, current);
                return current;
            }

            public <T> void method_42570(String key, class_7172<T> option) {
                DEFAULT_GAME_OPTIONS.put(key, option.method_41753());
            }
        });
    }

    @Override
    public void waitTick() {
        ThreadingImpl.checkOnGametestThread("waitTick");
        ThreadingImpl.runTick();
    }

    @Override
    public void waitTicks(int ticks) {
        ThreadingImpl.checkOnGametestThread("waitTicks");
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks cannot be negative");
        for (int i = 0; i < ticks; ++i) {
            ThreadingImpl.runTick();
        }
    }

    @Override
    public int waitFor(Predicate<class_310> predicate) {
        ThreadingImpl.checkOnGametestThread("waitFor");
        Preconditions.checkNotNull(predicate, (Object)"predicate");
        return this.waitFor(predicate, 200);
    }

    @Override
    public int waitFor(Predicate<class_310> predicate, int timeout) {
        ThreadingImpl.checkOnGametestThread("waitFor");
        Preconditions.checkNotNull(predicate, (Object)"predicate");
        if (timeout == -1) {
            int ticksWaited = 0;
            while (!((Boolean)this.computeOnClient(predicate::test)).booleanValue()) {
                ++ticksWaited;
                ThreadingImpl.runTick();
            }
            return ticksWaited;
        }
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0, (Object)"timeout must be positive");
        for (int i = 0; i < timeout; ++i) {
            if (((Boolean)this.computeOnClient(predicate::test)).booleanValue()) {
                return i;
            }
            ThreadingImpl.runTick();
        }
        if (!((Boolean)this.computeOnClient(predicate::test)).booleanValue()) {
            throw new AssertionError((Object)"Timed out waiting for predicate");
        }
        return timeout;
    }

    @Override
    public int waitForScreen(@Nullable Class<? extends class_437> screenClass) {
        ThreadingImpl.checkOnGametestThread("waitForScreen");
        if (screenClass == null) {
            return this.waitFor(client -> client.field_1755 == null);
        }
        return this.waitFor(client -> screenClass.isInstance(client.field_1755));
    }

    @Override
    public void setScreen(Supplier<@Nullable class_437> screen) {
        ThreadingImpl.checkOnGametestThread("setScreen");
        this.runOnClient(client -> client.method_1507((class_437)screen.get()));
    }

    @Override
    public void clickScreenButton(String translationKey) {
        ThreadingImpl.checkOnGametestThread("clickScreenButton");
        Preconditions.checkNotNull((Object)translationKey, (Object)"translationKey");
        this.runOnClient(client -> {
            if (!ClientGameTestContextImpl.tryClickScreenButtonImpl(client.field_1755, translationKey)) {
                throw new AssertionError((Object)"Could not find button '%s' in screen '%s'".formatted(translationKey, class_8144.method_49077((Object)client.field_1755, screen -> screen.getClass().getName())));
            }
        });
    }

    @Override
    public boolean tryClickScreenButton(String translationKey) {
        ThreadingImpl.checkOnGametestThread("tryClickScreenButton");
        Preconditions.checkNotNull((Object)translationKey, (Object)"translationKey");
        return (Boolean)this.computeOnClient(client -> ClientGameTestContextImpl.tryClickScreenButtonImpl(client.field_1755, translationKey));
    }

    private static boolean tryClickScreenButtonImpl(@Nullable class_437 screen, String translationKey) {
        if (screen == null) {
            return false;
        }
        String buttonText = class_2561.method_43471((String)translationKey).getString();
        ScreenAccessor screenAccessor = (ScreenAccessor)screen;
        for (class_4068 drawable : screenAccessor.getDrawables()) {
            class_4264 pressableWidget;
            if (drawable instanceof class_4264 && ClientGameTestContextImpl.pressMatchingButton((class_339)(pressableWidget = (class_4264)drawable), buttonText)) {
                return true;
            }
            if (!(drawable instanceof class_8021)) continue;
            class_8021 widget = (class_8021)drawable;
            MutableBoolean found = new MutableBoolean(false);
            widget.method_48206(clickableWidget -> {
                if (!found.booleanValue()) {
                    found.setValue(ClientGameTestContextImpl.pressMatchingButton(clickableWidget, buttonText));
                }
            });
            if (!found.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static boolean pressMatchingButton(class_339 widget, String text) {
        CyclingButtonWidgetAccessor accessor;
        class_4185 buttonWidget;
        if (widget instanceof class_4185 && text.equals((buttonWidget = (class_4185)widget).method_25369().getString())) {
            buttonWidget.method_25306();
            return true;
        }
        if (widget instanceof class_5676 && text.equals((accessor = (CyclingButtonWidgetAccessor)(buttonWidget = (class_5676)widget)).getOptionText().getString())) {
            buttonWidget.method_25306();
            return true;
        }
        return false;
    }

    @Override
    public Path takeScreenshot(String name) {
        ThreadingImpl.checkOnGametestThread("takeScreenshot");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return this.takeScreenshot(name, 1);
    }

    @Override
    public Path takeScreenshot(String name, int delay) {
        ThreadingImpl.checkOnGametestThread("takeScreenshot");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkArgument((delay >= 0 ? 1 : 0) != 0, (Object)"delay cannot be negative");
        this.waitTicks(delay);
        this.runOnClient(client -> class_318.method_22690((File)FabricLoader.getInstance().getGameDir().toFile(), (String)(name + ".png"), (class_276)client.method_1522(), message -> {}));
        return FabricLoader.getInstance().getGameDir().resolve("screenshots").resolve(name + ".png");
    }

    @Override
    public TestInputImpl getInput() {
        return this.input;
    }

    @Override
    public TestWorldBuilder worldBuilder() {
        return new TestWorldBuilderImpl(this);
    }

    @Override
    public void restoreDefaultGameOptions() {
        ThreadingImpl.checkOnGametestThread("restoreDefaultGameOptions");
        this.runOnClient(client -> ((GameOptionsAccessor)class_310.method_1551().field_1690).invokeAccept(new class_315.class_5823(this){

            public int method_33680(String key, int current) {
                return (Integer)DEFAULT_GAME_OPTIONS.get(key);
            }

            public boolean method_33684(String key, boolean current) {
                return (Boolean)DEFAULT_GAME_OPTIONS.get(key);
            }

            public String method_33683(String key, String current) {
                return (String)DEFAULT_GAME_OPTIONS.get(key);
            }

            public float method_33679(String key, float current) {
                return ((Float)DEFAULT_GAME_OPTIONS.get(key)).floatValue();
            }

            public <T> T method_33681(String key, T current, Function<String, T> decoder, Function<T, String> encoder) {
                return (T)DEFAULT_GAME_OPTIONS.get(key);
            }

            public <T> void method_42570(String key, class_7172<T> option) {
                option.method_41748(DEFAULT_GAME_OPTIONS.get(key));
            }
        }));
    }

    @Override
    public <E extends Throwable> void runOnClient(FailableConsumer<class_310, E> action) throws E {
        ThreadingImpl.checkOnGametestThread("runOnClient");
        Preconditions.checkNotNull(action, (Object)"action");
        ThreadingImpl.runOnClient(() -> action.accept((Object)class_310.method_1551()));
    }

    @Override
    public <T, E extends Throwable> T computeOnClient(FailableFunction<class_310, T, E> function) throws E {
        ThreadingImpl.checkOnGametestThread("computeOnClient");
        Preconditions.checkNotNull(function, (Object)"function");
        MutableObject result = new MutableObject();
        ThreadingImpl.runOnClient(() -> result.setValue(function.apply((Object)class_310.method_1551())));
        return (T)result.getValue();
    }
}

