/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.gametest;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.gametest.v1.ClientGameTestContext;
import net.fabricmc.fabric.api.client.gametest.v1.TestDedicatedServerContext;
import net.fabricmc.fabric.api.client.gametest.v1.TestServerConnection;
import net.fabricmc.fabric.impl.client.gametest.ClientGameTestImpl;
import net.fabricmc.fabric.impl.client.gametest.TestClientWorldContextImpl;
import net.fabricmc.fabric.impl.client.gametest.TestServerConnectionImpl;
import net.fabricmc.fabric.impl.client.gametest.TestServerContextImpl;
import net.fabricmc.fabric.impl.client.gametest.ThreadingImpl;
import net.minecraft.class_310;
import net.minecraft.class_3176;
import net.minecraft.class_412;
import net.minecraft.class_437;
import net.minecraft.class_639;
import net.minecraft.class_642;
import net.minecraft.server.MinecraftServer;

@Environment(value=EnvType.CLIENT)
public class TestDedicatedServerContextImpl
extends TestServerContextImpl
implements TestDedicatedServerContext {
    private final ClientGameTestContext context;

    public TestDedicatedServerContextImpl(ClientGameTestContext context, class_3176 server) {
        super((MinecraftServer)server);
        this.context = context;
    }

    @Override
    public TestServerConnection connect() {
        ThreadingImpl.checkOnGametestThread("connect");
        this.context.runOnClient(client -> {
            class_642 serverInfo = new class_642("localhost", this.getConnectionAddress(), class_642.class_8678.field_45611);
            class_412.method_36877((class_437)client.field_1755, (class_310)client, (class_639)class_639.method_2950((String)this.getConnectionAddress()), (class_642)serverInfo, (boolean)false, null);
        });
        ClientGameTestImpl.waitForWorldLoad(this.context);
        TestClientWorldContextImpl clientWorld = new TestClientWorldContextImpl(this.context);
        return new TestServerConnectionImpl(this.context, clientWorld);
    }

    private String getConnectionAddress() {
        return "localhost:" + this.server.method_3756();
    }

    @Override
    public void close() {
        ThreadingImpl.checkOnGametestThread("close");
        if (!ThreadingImpl.isServerRunning || !this.server.method_3777().isAlive()) {
            throw new AssertionError((Object)"Stopped the dedicated server before closing the dedicated server context");
        }
        this.server.method_3747(false);
        this.context.waitFor(client -> !ThreadingImpl.isServerRunning && !this.server.method_3777().isAlive());
    }
}

