/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.gametest;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.gametest.v1.ClientGameTestContext;
import net.fabricmc.fabric.api.client.gametest.v1.TestClientWorldContext;
import net.fabricmc.fabric.api.client.gametest.v1.TestServerContext;
import net.fabricmc.fabric.api.client.gametest.v1.TestSingleplayerContext;
import net.fabricmc.fabric.api.client.gametest.v1.TestWorldSave;
import net.fabricmc.fabric.impl.client.gametest.TestClientWorldContextImpl;
import net.fabricmc.fabric.impl.client.gametest.TestServerContextImpl;
import net.fabricmc.fabric.impl.client.gametest.ThreadingImpl;
import net.minecraft.class_433;
import net.minecraft.class_442;
import net.minecraft.server.MinecraftServer;

@Environment(value=EnvType.CLIENT)
public class TestSingleplayerContextImpl
implements TestSingleplayerContext {
    private final ClientGameTestContext context;
    private final TestWorldSave worldSave;
    private final TestClientWorldContext clientWorld;
    private final TestServerContext server;

    public TestSingleplayerContextImpl(ClientGameTestContext context, TestWorldSave worldSave, MinecraftServer server) {
        this.context = context;
        this.worldSave = worldSave;
        this.clientWorld = new TestClientWorldContextImpl(context);
        this.server = new TestServerContextImpl(server);
    }

    @Override
    public TestWorldSave getWorldSave() {
        return this.worldSave;
    }

    @Override
    public TestClientWorldContext getClientWorld() {
        return this.clientWorld;
    }

    @Override
    public TestServerContext getServer() {
        return this.server;
    }

    @Override
    public void close() {
        ThreadingImpl.checkOnGametestThread("close");
        this.context.runOnClient(client -> {
            if (client.field_1687 == null) {
                throw new IllegalStateException("Exited the world before closing singleplayer context");
            }
        });
        this.context.setScreen(() -> new class_433(true));
        this.context.clickScreenButton("menu.returnToMenu");
        this.context.waitForScreen(class_442.class);
        this.context.waitFor(client -> !ThreadingImpl.isServerRunning && client.field_1687 == null, 1200);
    }
}

