/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.gametest;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.gametest.v1.ClientGameTestContext;
import net.fabricmc.fabric.api.client.gametest.v1.TestSingleplayerContext;
import net.fabricmc.fabric.api.client.gametest.v1.TestWorldSave;
import net.fabricmc.fabric.impl.client.gametest.ClientGameTestImpl;
import net.fabricmc.fabric.impl.client.gametest.TestSingleplayerContextImpl;
import net.fabricmc.fabric.impl.client.gametest.ThreadingImpl;
import net.minecraft.class_310;
import net.minecraft.server.MinecraftServer;

@Environment(value=EnvType.CLIENT)
public final class TestWorldSaveImpl
implements TestWorldSave {
    private final ClientGameTestContext context;
    private final Path saveDirectory;

    public TestWorldSaveImpl(ClientGameTestContext context, Path saveDirectory) {
        this.context = context;
        this.saveDirectory = saveDirectory;
    }

    @Override
    public Path getSaveDirectory() {
        return this.saveDirectory;
    }

    @Override
    public TestSingleplayerContext open() {
        ThreadingImpl.checkOnGametestThread("open");
        Preconditions.checkState((!ThreadingImpl.isServerRunning ? 1 : 0) != 0, (Object)"Cannot open a world when a server is running");
        this.context.runOnClient(client -> client.method_41735().method_57784(this.saveDirectory.getFileName().toString(), () -> {
            throw new AssertionError((Object)"Level loading should not be canceled");
        }));
        ClientGameTestImpl.waitForWorldLoad(this.context);
        MinecraftServer server = (MinecraftServer)this.context.computeOnClient(class_310::method_1576);
        return new TestSingleplayerContextImpl(this.context, this, server);
    }
}

