/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.gametest.context;

import java.util.Objects;
import net.fabricmc.fabric.api.client.gametest.v1.context.ClientGameTestContext;
import net.fabricmc.fabric.api.client.gametest.v1.context.TestClientWorldContext;
import net.fabricmc.fabric.impl.client.gametest.threading.ThreadingImpl;
import net.fabricmc.fabric.mixin.client.gametest.ClientChunkCacheAccessor;
import net.fabricmc.fabric.mixin.client.gametest.ClientChunkCacheStorageAccessor;
import net.fabricmc.fabric.mixin.client.gametest.ClientLevelAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public class TestClientWorldContextImpl
implements TestClientWorldContext {
    private final ClientGameTestContext context;

    public TestClientWorldContextImpl(ClientGameTestContext context) {
        this.context = context;
    }

    @Override
    public int waitForChunksDownload(int timeout) {
        ThreadingImpl.checkOnGametestThread("waitForChunksDownload");
        return this.context.waitFor(TestClientWorldContextImpl::areChunksLoaded, timeout);
    }

    @Override
    public int waitForChunksRender(boolean waitForDownload, int timeout) {
        ThreadingImpl.checkOnGametestThread("waitForChunksRender");
        return this.context.waitFor(client -> (!waitForDownload || TestClientWorldContextImpl.areChunksLoaded(client)) && TestClientWorldContextImpl.areChunksRendered(client), timeout);
    }

    private static boolean areChunksLoaded(Minecraft client) {
        int viewDistance = client.options.getEffectiveRenderDistance();
        ClientLevel world = Objects.requireNonNull(client.level);
        ClientChunkCache.Storage chunks = ((ClientChunkCacheAccessor)world.getChunkSource()).getChunks();
        ClientChunkCacheStorageAccessor chunksAccessor = (ClientChunkCacheStorageAccessor)chunks;
        int centerChunkX = chunksAccessor.getCenterChunkX();
        int centerChunkZ = chunksAccessor.getCenterChunkZ();
        for (int dz = -viewDistance; dz <= viewDistance; ++dz) {
            for (int dx = -viewDistance; dx <= viewDistance; ++dx) {
                if (world.getChunk(centerChunkX + dx, centerChunkZ + dz, ChunkStatus.FULL, false) != null) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean areChunksRendered(Minecraft client) {
        ClientLevel world = Objects.requireNonNull(client.level);
        return ((ClientLevelAccessor)world).getChunkUpdaters().isEmpty() && client.levelRenderer.hasRenderedAllSections();
    }
}

