/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.gametest.context;

import net.fabricmc.fabric.api.client.gametest.v1.context.ClientGameTestContext;
import net.fabricmc.fabric.api.client.gametest.v1.context.TestClientWorldContext;
import net.fabricmc.fabric.api.client.gametest.v1.context.TestServerConnection;
import net.fabricmc.fabric.impl.client.gametest.threading.ThreadingImpl;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;

public class TestServerConnectionImpl
implements TestServerConnection {
    private final ClientGameTestContext context;
    private final TestClientWorldContext clientWorld;

    public TestServerConnectionImpl(ClientGameTestContext context, TestClientWorldContext clientWorld) {
        this.context = context;
        this.clientWorld = clientWorld;
    }

    @Override
    public TestClientWorldContext getClientWorld() {
        return this.clientWorld;
    }

    @Override
    public void close() {
        ThreadingImpl.checkOnGametestThread("close");
        this.context.runOnClient(client -> {
            if (client.level == null) {
                throw new AssertionError((Object)"Disconnected from server before closing the test server connection");
            }
            client.level.disconnect((Component)Component.literal((String)"Disconnecting"));
            client.disconnectWithSavingScreen();
        });
        this.context.waitFor(client -> client.level == null);
        this.context.setScreen(TitleScreen::new);
    }
}

