/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.content.registry;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2609;
import net.minecraft.class_3494;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FuelRegistryImpl
implements FuelRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Object2IntMap<class_1935> itemCookTimes = new Object2IntLinkedOpenHashMap();
    private final Object2IntMap<class_3494<class_1792>> tagCookTimes = new Object2IntLinkedOpenHashMap();
    private volatile Map<class_1792, Integer> fuelTimeCache = null;

    public FuelRegistryImpl() {
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, serverResourceManager, success) -> {
            if (success) {
                this.resetCache();
            }
        });
    }

    public Map<class_1792, Integer> getFuelTimes() {
        Map<class_1792, Integer> ret = this.fuelTimeCache;
        if (ret == null) {
            this.fuelTimeCache = ret = new IdentityHashMap<class_1792, Integer>(class_2609.method_11196());
        }
        return ret;
    }

    @Override
    public Integer get(class_1935 item) {
        return this.getFuelTimes().get(item.method_8389());
    }

    @Override
    public void add(class_1935 item, Integer cookTime) {
        if (cookTime > Short.MAX_VALUE) {
            LOGGER.warn("Tried to register an overly high cookTime: " + cookTime + " > 32767! (" + item + ")");
        }
        this.itemCookTimes.put((Object)item, cookTime.intValue());
        this.resetCache();
    }

    @Override
    public void add(class_3494<class_1792> tag, Integer cookTime) {
        if (cookTime > Short.MAX_VALUE) {
            LOGGER.warn("Tried to register an overly high cookTime: " + cookTime + " > 32767! (" + FuelRegistryImpl.getTagName(tag) + ")");
        }
        this.tagCookTimes.put(tag, cookTime.intValue());
        this.resetCache();
    }

    @Override
    public void remove(class_1935 item) {
        this.add(item, (Integer)0);
        this.resetCache();
    }

    @Override
    public void remove(class_3494<class_1792> tag) {
        this.add(tag, (Integer)0);
        this.resetCache();
    }

    @Override
    public void clear(class_1935 item) {
        this.itemCookTimes.removeInt((Object)item);
        this.resetCache();
    }

    @Override
    public void clear(class_3494<class_1792> tag) {
        this.tagCookTimes.removeInt(tag);
        this.resetCache();
    }

    public void apply(Map<class_1792, Integer> map) {
        int time;
        for (class_3494 tag : this.tagCookTimes.keySet()) {
            time = this.tagCookTimes.getInt((Object)tag);
            if (time <= 0) {
                for (class_1792 i : tag.method_15138()) {
                    map.remove(i);
                }
                continue;
            }
            class_2609.method_11194(map, (class_3494)tag, (int)time);
        }
        for (class_1935 item : this.itemCookTimes.keySet()) {
            time = this.itemCookTimes.getInt((Object)item);
            if (time <= 0) {
                map.remove(item.method_8389());
                continue;
            }
            class_2609.method_11202(map, (class_1935)item, (int)time);
        }
    }

    private static String getTagName(class_3494<?> tag) {
        if (tag instanceof class_3494.class_5123) {
            return ((class_3494.class_5123)tag).method_26791().toString();
        }
        return tag.toString();
    }

    public void resetCache() {
        this.fuelTimeCache = null;
    }
}

