/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.content.registry;

import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_3962;
import net.minecraft.class_6862;

public class CompostingChanceRegistryImpl implements CompostingChanceRegistry {
	@Override
	public Float get(class_1935 item) {
		return class_3962.field_17566.getOrDefault(item.method_8389(), 0.0F);
	}

	@Override
	public void add(class_1935 item, Float value) {
		class_3962.field_17566.put(item.method_8389(), value);
	}

	@Override
	public void add(class_6862<class_1792> tag, Float value) {
		throw new UnsupportedOperationException("Tags currently not supported!");
	}

	@Override
	public void remove(class_1935 item) {
		class_3962.field_17566.removeFloat(item.method_8389());
	}

	@Override
	public void remove(class_6862<class_1792> tag) {
		throw new UnsupportedOperationException("Tags currently not supported!");
	}

	@Override
	public void clear(class_1935 item) {
		throw new UnsupportedOperationException("CompostingChanceRegistry operates directly on the vanilla map - clearing not supported!");
	}

	@Override
	public void clear(class_6862<class_1792> tag) {
		throw new UnsupportedOperationException("CompostingChanceRegistry operates directly on the vanilla map - clearing not supported!");
	}
}
