/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.attachment.sync;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.attachment.v1.AttachmentTarget;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.impl.attachment.AttachmentRegistryImpl;
import net.fabricmc.fabric.impl.attachment.AttachmentTypeImpl;
import net.fabricmc.fabric.impl.attachment.sync.AttachmentSyncException;
import net.fabricmc.fabric.impl.attachment.sync.AttachmentTargetInfo;
import net.fabricmc.fabric.impl.attachment.sync.SupportedAttachmentsClientConnection;
import net.fabricmc.fabric.impl.attachment.sync.s2c.AttachmentSyncPayloadS2C;
import net.fabricmc.fabric.mixin.attachment.CustomPayloadS2CPacketAccessor;
import net.fabricmc.fabric.mixin.attachment.VarIntsAccessor;
import net.fabricmc.fabric.mixin.networking.accessor.ServerCommonNetworkHandlerAccessor;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record AttachmentChange(AttachmentTargetInfo<?> targetInfo, AttachmentType<?> type, byte[] data) {
    public static final class_9139<class_2540, AttachmentChange> PACKET_CODEC = class_9139.method_56436(AttachmentTargetInfo.PACKET_CODEC, AttachmentChange::targetInfo, (class_9139)class_2960.field_48267.method_56432(id -> Objects.requireNonNull(AttachmentRegistryImpl.get(id)), AttachmentType::identifier), AttachmentChange::type, (class_9139)class_9135.field_48987, AttachmentChange::data, AttachmentChange::new);
    private static final int MAX_PADDING_SIZE_IN_BYTES = 265;
    private static final int MAX_DATA_SIZE_IN_BYTES = CustomPayloadS2CPacketAccessor.getMaxPayloadSize() - 265;
    private static final boolean DISCONNECT_ON_UNKNOWN_TARGETS = System.getProperty("fabric.attachment.disconnect_on_unknown_targets") != null;
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentChange.class);

    public static AttachmentChange create(AttachmentTargetInfo<?> targetInfo, AttachmentType<?> type, @Nullable Object value, class_5455 dynamicRegistryManager) {
        class_9139 codec = ((AttachmentTypeImpl)type).packetCodec();
        Objects.requireNonNull(codec, "attachment packet codec cannot be null");
        Objects.requireNonNull(dynamicRegistryManager, "dynamic registry manager cannot be null");
        class_9129 buf = new class_9129((ByteBuf)PacketByteBufs.create(), dynamicRegistryManager);
        if (value != null) {
            buf.method_52964(true);
            codec.encode((Object)buf, value);
        } else {
            buf.method_52964(false);
        }
        byte[] encoded = buf.array();
        if (encoded.length > MAX_DATA_SIZE_IN_BYTES) {
            throw new IllegalArgumentException("Data for attachment '%s' was too big (%d bytes, over maximum %d)".formatted(type.identifier(), encoded.length, MAX_DATA_SIZE_IN_BYTES));
        }
        return new AttachmentChange(targetInfo, type, encoded);
    }

    public static void partitionAndSendPackets(List<AttachmentChange> changes, class_3222 player) {
        int maxVarIntSize;
        Set<class_2960> supported = ((SupportedAttachmentsClientConnection)((ServerCommonNetworkHandlerAccessor)player.field_13987).getConnection()).fabric_getSupportedAttachments();
        changes.sort(Comparator.comparingInt(c -> c.data().length));
        ArrayList<AttachmentChange> packetChanges = new ArrayList<AttachmentChange>();
        int byteSize = maxVarIntSize = VarIntsAccessor.getMaxByteSize();
        for (AttachmentChange change : changes) {
            if (!supported.contains(change.type.identifier())) continue;
            int size = 265 + change.data.length;
            if (byteSize + size > MAX_DATA_SIZE_IN_BYTES) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)new AttachmentSyncPayloadS2C(packetChanges));
                packetChanges.clear();
                byteSize = maxVarIntSize;
            }
            packetChanges.add(change);
            byteSize += size;
        }
        if (!packetChanges.isEmpty()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new AttachmentSyncPayloadS2C(packetChanges));
        }
    }

    @Nullable
    public Object decodeValue(class_5455 dynamicRegistryManager) {
        class_9139 codec = ((AttachmentTypeImpl)this.type).packetCodec();
        Objects.requireNonNull(codec, "codec was null");
        Objects.requireNonNull(dynamicRegistryManager, "dynamic registry manager cannot be null");
        class_9129 buf = new class_9129(Unpooled.copiedBuffer((byte[])this.data), dynamicRegistryManager);
        if (!buf.readBoolean()) {
            return null;
        }
        return codec.decode((Object)buf);
    }

    public void tryApply(class_1937 world) throws AttachmentSyncException {
        AttachmentTarget target = this.targetInfo.getTarget(world);
        Object value = this.decodeValue(world.method_30349());
        if (target == null) {
            class_5250 errorMessageText = class_2561.method_43473();
            errorMessageText.method_10852((class_2561)class_2561.method_43471((String)"fabric-data-attachment-api-v1.unknown-target.title").method_27692(class_124.field_1061)).method_10852(class_5244.field_33849);
            errorMessageText.method_10852(class_5244.field_33849);
            errorMessageText.method_10852((class_2561)class_2561.method_43469((String)"fabric-data-attachment-api-v1.unknown-target.attachment-identifier", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(this.type.identifier())).method_27692(class_124.field_1054)})).method_10852(class_5244.field_33849);
            errorMessageText.method_10852((class_2561)class_2561.method_43469((String)"fabric-data-attachment-api-v1.unknown-target.world", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(world.method_27983().method_29177())).method_27692(class_124.field_1054)})).method_10852(class_5244.field_33849);
            this.targetInfo.appendDebugInformation(errorMessageText);
            if (DISCONNECT_ON_UNKNOWN_TARGETS) {
                throw new AttachmentSyncException((class_2561)errorMessageText);
            }
            LOGGER.warn(errorMessageText.getString().trim());
            return;
        }
        target.setAttached(this.type, value);
    }
}

