/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.attachment;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import net.fabricmc.fabric.impl.attachment.AttachmentTargetImpl;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentPersistentState
extends SavedData {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentPersistentState.class);
    public static final String ID = "fabric_attachments";
    private final AttachmentTargetImpl worldTarget;
    private final boolean wasSerialized;

    public AttachmentPersistentState(ServerLevel world) {
        this.worldTarget = (AttachmentTargetImpl)world;
        this.wasSerialized = this.worldTarget.fabric_hasPersistentAttachments();
    }

    public static Codec<AttachmentPersistentState> codec(final ServerLevel world) {
        final ProblemReporter.PathElement reporterContext = () -> "AttachmentPersistentState @ " + String.valueOf(world.dimension().identifier());
        return Codec.of((Encoder)new Encoder<AttachmentPersistentState>(){

            public <T> DataResult<T> encode(AttachmentPersistentState input, DynamicOps<T> ops, T prefix) {
                try (ProblemReporter.ScopedCollector reporter = new ProblemReporter.ScopedCollector(reporterContext, LOGGER);){
                    TagValueOutput writeView = TagValueOutput.createWithoutContext((ProblemReporter)reporter);
                    ((AttachmentTargetImpl)world).fabric_writeAttachmentsToNbt((ValueOutput)writeView);
                    DataResult dataResult = DataResult.success((Object)NbtOps.INSTANCE.convertTo(ops, (Tag)writeView.buildResult()));
                    return dataResult;
                }
            }
        }, (Decoder)new Decoder<AttachmentPersistentState>(){

            public <T> DataResult<Pair<AttachmentPersistentState, T>> decode(DynamicOps<T> ops, T input) {
                try (ProblemReporter.ScopedCollector reporter = new ProblemReporter.ScopedCollector(reporterContext, LOGGER);){
                    ValueInput readView = TagValueInput.create((ProblemReporter)reporter, (HolderLookup.Provider)world.registryAccess(), (CompoundTag)((CompoundTag)ops.convertTo((DynamicOps)NbtOps.INSTANCE, input)));
                    ((AttachmentTargetImpl)world).fabric_readAttachmentsFromNbt(readView);
                    DataResult dataResult = DataResult.success((Object)Pair.of((Object)((Object)new AttachmentPersistentState(world)), (Object)ops.empty()));
                    return dataResult;
                }
            }
        });
    }

    public boolean isDirty() {
        return this.wasSerialized || this.worldTarget.fabric_hasPersistentAttachments();
    }
}

