/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.attachment.sync;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.EntityTrackingEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.impl.attachment.AttachmentEntrypoint;
import net.fabricmc.fabric.impl.attachment.AttachmentRegistryImpl;
import net.fabricmc.fabric.impl.attachment.AttachmentTargetImpl;
import net.fabricmc.fabric.impl.attachment.sync.AttachmentChange;
import net.fabricmc.fabric.impl.attachment.sync.SupportedAttachmentsClientConnection;
import net.fabricmc.fabric.impl.attachment.sync.c2s.AcceptedAttachmentsPayloadC2S;
import net.fabricmc.fabric.impl.attachment.sync.s2c.AttachmentSyncPayloadS2C;
import net.fabricmc.fabric.impl.attachment.sync.s2c.RequestAcceptedAttachmentsPayloadS2C;
import net.fabricmc.fabric.mixin.networking.accessor.ServerCommonPacketListenerImplAccessor;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;

public class AttachmentSync
implements ModInitializer {
    public static final int MAX_IDENTIFIER_SIZE = 256;

    public static AcceptedAttachmentsPayloadC2S createResponsePayload() {
        return new AcceptedAttachmentsPayloadC2S(AttachmentRegistryImpl.getSyncableAttachments());
    }

    public static void trySync(AttachmentChange change, ServerPlayer player) {
        Set<Identifier> supported = ((SupportedAttachmentsClientConnection)((ServerCommonPacketListenerImplAccessor)player.connection).getConnection()).fabric_getSupportedAttachments();
        if (supported.contains(change.type().identifier())) {
            ServerPlayNetworking.send((ServerPlayer)player, (CustomPacketPayload)new AttachmentSyncPayloadS2C(List.of(change)));
        }
    }

    private static Set<Identifier> decodeResponsePayload(AcceptedAttachmentsPayloadC2S payload) {
        Set<Identifier> atts = payload.acceptedAttachments();
        Set<Identifier> syncable = AttachmentRegistryImpl.getSyncableAttachments();
        atts.retainAll(syncable);
        if (atts.size() < syncable.size()) {
            AttachmentEntrypoint.LOGGER.warn("Client does not support the syncable attachments {}", (Object)syncable.stream().filter(id -> !atts.contains(id)).map(Identifier::toString).collect(Collectors.joining(", ")));
        }
        return atts;
    }

    public void onInitialize() {
        PayloadTypeRegistry.configurationC2S().register(AcceptedAttachmentsPayloadC2S.ID, AcceptedAttachmentsPayloadC2S.CODEC);
        PayloadTypeRegistry.configurationS2C().register(RequestAcceptedAttachmentsPayloadS2C.ID, RequestAcceptedAttachmentsPayloadS2C.CODEC);
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((ServerConfigurationPacketListenerImpl)handler, (Identifier)RequestAcceptedAttachmentsPayloadS2C.PACKET_ID)) {
                handler.addTask((ConfigurationTask)new AttachmentSyncTask());
            } else {
                AttachmentEntrypoint.LOGGER.debug("Couldn't send attachment configuration packet to client, as the client cannot receive the payload.");
            }
        });
        ServerConfigurationNetworking.registerGlobalReceiver(AcceptedAttachmentsPayloadC2S.ID, (payload, context) -> {
            Set<Identifier> supportedAttachments = AttachmentSync.decodeResponsePayload(payload);
            Connection connection = ((ServerCommonPacketListenerImplAccessor)context.networkHandler()).getConnection();
            ((SupportedAttachmentsClientConnection)connection).fabric_setSupportedAttachments(supportedAttachments);
            context.networkHandler().completeTask(AttachmentSyncTask.KEY);
        });
        PayloadTypeRegistry.playS2C().register(AttachmentSyncPayloadS2C.ID, AttachmentSyncPayloadS2C.CODEC);
        ServerPlayerEvents.JOIN.register(player -> {
            ArrayList<AttachmentChange> changes = new ArrayList<AttachmentChange>();
            ((AttachmentTargetImpl)player.level()).fabric_computeInitialSyncChanges(player, changes::add);
            ((AttachmentTargetImpl)player).fabric_computeInitialSyncChanges(player, changes::add);
            if (!changes.isEmpty()) {
                AttachmentChange.partitionAndSendPackets(changes, player);
            }
        });
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> {
            ArrayList<AttachmentChange> changes = new ArrayList<AttachmentChange>();
            ((AttachmentTargetImpl)destination).fabric_computeInitialSyncChanges(player, changes::add);
            if (!changes.isEmpty()) {
                AttachmentChange.partitionAndSendPackets(changes, player);
            }
        });
        EntityTrackingEvents.START_TRACKING.register((trackedEntity, player) -> {
            ArrayList<AttachmentChange> changes = new ArrayList<AttachmentChange>();
            ((AttachmentTargetImpl)trackedEntity).fabric_computeInitialSyncChanges(player, changes::add);
            if (!changes.isEmpty()) {
                AttachmentChange.partitionAndSendPackets(changes, player);
            }
        });
    }

    private record AttachmentSyncTask() implements ConfigurationTask
    {
        public static final ConfigurationTask.Type KEY = new ConfigurationTask.Type(RequestAcceptedAttachmentsPayloadS2C.PACKET_ID.toString());

        public void start(Consumer<Packet<?>> sender) {
            sender.accept(ServerConfigurationNetworking.createS2CPacket((CustomPacketPayload)RequestAcceptedAttachmentsPayloadS2C.INSTANCE));
        }

        public ConfigurationTask.Type type() {
            return KEY;
        }
    }
}

