/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1;

import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_155;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7784;
import org.jetbrains.annotations.ApiStatus;

public final class FabricDataGenerator
extends class_2403 {
    private final ModContainer modContainer;
    private final boolean strictValidation;
    private final FabricDataOutput fabricOutput;
    private final CompletableFuture<class_7225.class_7874> registriesFuture;

    @ApiStatus.Internal
    public FabricDataGenerator(Path output, ModContainer mod, boolean strictValidation, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, class_155.method_16673(), true);
        this.modContainer = Objects.requireNonNull(mod);
        this.strictValidation = strictValidation;
        this.fabricOutput = new FabricDataOutput(mod, output, strictValidation);
        this.registriesFuture = registriesFuture;
    }

    public Pack createPack() {
        return new Pack(true, this.modContainer.getMetadata().getName(), this.fabricOutput);
    }

    public Pack createBuiltinResourcePack(class_2960 id) {
        Path path = this.field_40596.method_45971().resolve("resourcepacks").resolve(id.method_12832());
        return new Pack(true, id.toString(), new FabricDataOutput(this.modContainer, path, this.strictValidation));
    }

    public ModContainer getModContainer() {
        return this.modContainer;
    }

    public String getModId() {
        return this.getModContainer().getMetadata().getId();
    }

    public boolean isStrictValidationEnabled() {
        return this.strictValidation;
    }

    @Deprecated
    public class_2403.class_7856 method_46564(boolean shouldRun) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public class_2403.class_7856 method_46565(boolean shouldRun, String packName) {
        throw new UnsupportedOperationException();
    }

    public final class Pack
    extends class_2403.class_7856 {
        private Pack(boolean shouldRun, String name, FabricDataOutput output) {
            super((class_2403)FabricDataGenerator.this, shouldRun, name, (class_7784)output);
        }

        public <T extends class_2405> T addProvider(Factory<T> factory) {
            return (T)super.method_46566(output -> factory.create((FabricDataOutput)output));
        }

        public <T extends class_2405> T addProvider(RegistryDependentFactory<T> factory) {
            return (T)super.method_46566(output -> factory.create((FabricDataOutput)output, FabricDataGenerator.this.registriesFuture));
        }

        @FunctionalInterface
        public static interface Factory<T extends class_2405> {
            public T create(FabricDataOutput var1);
        }

        @FunctionalInterface
        public static interface RegistryDependentFactory<T extends class_2405> {
            public T create(FabricDataOutput var1, CompletableFuture<class_7225.class_7874> var2);
        }
    }
}

