/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.datagen.recipe;

import net.minecraft.class_2960;
import net.minecraft.class_8076;
import net.minecraft.class_8790;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(class_8076.class)
abstract class SmithingTrimRecipeJsonBuilderMixin {
	@ModifyVariable(method = "offerTo", at = @At("HEAD"), argsOnly = true)
	private class_2960 modifyRecipeId(class_2960 recipeId, class_8790 exporter) {
		return exporter.getRecipeIdentifier(recipeId);
	}
}
