/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.datagen.v1.builder;

import com.mojang.serialization.Codec;
import java.util.Objects;
import net.fabricmc.fabric.impl.datagen.client.SoundTypeBuilderImpl;
import net.minecraft.core.Holder;
import net.minecraft.resources.Identifier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.Util;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

@ApiStatus.NonExtendable
public interface SoundTypeBuilder {
    public static SoundTypeBuilder of(SoundEvent event) {
        Objects.requireNonNull(event, "Sound event cannot be null.");
        return SoundTypeBuilder.of().subtitle(Util.makeDescriptionId((String)"subtitles", (Identifier)event.location()));
    }

    public static SoundTypeBuilder of() {
        return new SoundTypeBuilderImpl();
    }

    public SoundTypeBuilder category(SoundSource var1);

    public SoundTypeBuilder subtitle(@Nullable String var1);

    public SoundTypeBuilder sound(EntryBuilder var1);

    public SoundTypeBuilder sound(EntryBuilder var1, int var2);

    @ApiStatus.NonExtendable
    public static interface EntryBuilder {
        public static final float DEFAULT_VOLUME = 1.0f;
        public static final float DEFAULT_PITCH = 1.0f;
        public static final int DEFAULT_WEIGHT = 1;
        public static final int DEFAULT_ATTENUATION_DISTANCE = 16;

        public static EntryBuilder create(RegistrationType type, Identifier id) {
            return SoundTypeBuilderImpl.EntryBuilderImpl.create(type, id);
        }

        public static EntryBuilder ofFile(Identifier soundFile) {
            return SoundTypeBuilderImpl.EntryBuilderImpl.ofFile(soundFile);
        }

        public static EntryBuilder ofEvent(SoundEvent event) {
            return SoundTypeBuilderImpl.EntryBuilderImpl.ofEvent(event);
        }

        public static EntryBuilder ofEvent(Holder<SoundEvent> event) {
            return SoundTypeBuilderImpl.EntryBuilderImpl.ofEvent(event);
        }

        public EntryBuilder volume(float var1);

        public EntryBuilder pitch(float var1);

        public EntryBuilder attenuationDistance(int var1);

        public EntryBuilder weight(int var1);

        public EntryBuilder stream(boolean var1);

        public EntryBuilder preload(boolean var1);
    }

    public static enum RegistrationType implements StringRepresentable
    {
        FILE("file"),
        SOUND_EVENT("event");

        public static final Codec<RegistrationType> CODEC;
        private final String name;

        private RegistrationType(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(RegistrationType::values);
        }
    }
}

