/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.datagen.v1;

import java.nio.file.Path;
import java.util.Collections;
import java.util.function.Function;

import org.jetbrains.annotations.ApiStatus;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_155;
import net.minecraft.class_2403;
import net.minecraft.class_2405;

/**
 * An extension to vanilla's {@link class_2403} providing mod specific data, and helper functions.
 */
public final class FabricDataGenerator extends class_2403 {
	private final ModContainer modContainer;
	private final boolean strictValidation;

	@ApiStatus.Internal
	public FabricDataGenerator(Path output, ModContainer mod, boolean strictValidation) {
		super(output, Collections.emptyList(), class_155.method_16673(), true);
		this.modContainer = mod;
		this.strictValidation = strictValidation;
	}

	/**
	 * Helper overloaded method to aid with registering a {@link class_2405} that has a single argument constructor for a {@link FabricDataGenerator}.
	 *
	 * @return The {@link class_2405}
	 */
	public <P extends class_2405> P addProvider(Function<FabricDataGenerator, P> provider) {
		return addProvider(true, provider);
	}

	/**
	 * Helper overloaded method to aid with registering a {@link class_2405} that has a single argument constructor for a {@link FabricDataGenerator}.
	 *
	 * @return The {@link class_2405}
	 */
	public <P extends class_2405> P addProvider(boolean include, Function<FabricDataGenerator, P> provider) {
		P p = provider.apply(this);
		method_10314(include, p);
		return p;
	}

	/**
	 * Helper overloaded method to aid with registering a {@link class_2405}.
	 */
	public void addProvider(class_2405 dataProvider) {
		super.method_10314(true, dataProvider);
	}

	/**
	 * Returns the {@link ModContainer} for the mod that this data generator has been created for.
	 *
	 * @return a {@link ModContainer} instance
	 */
	public ModContainer getModContainer() {
		return modContainer;
	}

	/**
	 * Returns the mod ID for the mod that this data generator has been created for.
	 *
	 * @return a mod ID
	 */
	public String getModId() {
		return getModContainer().getMetadata().getId();
	}

	/**
	 * When enabled data providers can do strict validation to ensure that all entries have data generated for them.
	 *
	 * @return if strict validation should be enabled
	 */
	public boolean isStrictValidationEnabled() {
		return strictValidation;
	}
}
