/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.datagen.v1.provider;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

import com.google.common.collect.Sets;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_173;
import net.minecraft.class_176;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2430;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import net.minecraft.class_52;

/**
 * Extend this class and implement {@link FabricBlockLootTableProvider#generateBlockLootTables}.
 *
 * <p>Register an instance of the class with {@link FabricDataGenerator#addProvider} in a {@link net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint}
 */
public abstract class FabricBlockLootTableProvider extends class_2430 implements FabricLootTableProvider {
	protected final FabricDataGenerator dataGenerator;
	private final Set<class_2960> excludedFromStrictValidation = new HashSet<>();

	protected FabricBlockLootTableProvider(FabricDataGenerator dataGenerator) {
		this.dataGenerator = dataGenerator;
	}

	/**
	 * Implement this method to add block drops.
	 *
	 * <p>Use the range of {@link class_2430#method_16329} methods to generate block drops.
	 */
	protected abstract void generateBlockLootTables();

	/**
	 * Disable strict validation for the passed block.
	 */
	public void excludeFromStrictValidation(class_2248 block) {
		excludedFromStrictValidation.add(class_2378.field_11146.method_10221(block));
	}

	@Override
	public class_176 getLootContextType() {
		return class_173.field_1172;
	}

	@Override
	public FabricDataGenerator getFabricDataGenerator() {
		return dataGenerator;
	}

	@Override
	public void method_10379(BiConsumer<class_2960, class_52.class_53> biConsumer) {
		generateBlockLootTables();

		for (Map.Entry<class_2960, class_52.class_53> entry : field_16493.entrySet()) {
			class_2960 identifier = entry.getKey();

			if (identifier.equals(class_39.field_844)) {
				continue;
			}

			biConsumer.accept(identifier, entry.getValue());
		}

		if (dataGenerator.isStrictValidationEnabled()) {
			Set<class_2960> missing = Sets.newHashSet();

			for (class_2960 blockId : class_2378.field_11146.method_10235()) {
				if (blockId.method_12836().equals(dataGenerator.getModId())) {
					if (!field_16493.containsKey(class_2378.field_11146.method_10223(blockId).method_26162())) {
						missing.add(blockId);
					}
				}
			}

			missing.removeAll(excludedFromStrictValidation);

			if (!missing.isEmpty()) {
				throw new IllegalStateException("Missing loot table(s) for %s".formatted(missing));
			}
		}
	}

	@Override
	public String method_10321() {
		return "Block Loot Tables";
	}
}
