/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.event.interaction.client;

import com.llamalad7.mixinextras.sugar.Local;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.api.event.client.player.ClientPreAttackCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2824;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3966;
import net.minecraft.class_634;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Mixin(class_310.class)
public abstract class MinecraftClientMixin {
	@Unique
	private boolean attackCancelled;

	@Shadow
	private class_746 player;

	@Shadow
	public abstract class_634 getNetworkHandler();

	@Shadow
	@Final
	public class_315 options;

	@Shadow
	@Nullable
	public class_636 interactionManager;

	@Shadow
	@Nullable
	public class_638 world;

	@Inject(
			at = @At(
					value = "INVOKE",
					target = "net/minecraft/client/network/ClientPlayerInteractionManager.interactEntityAtLocation(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/util/hit/EntityHitResult;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResult;"
			),
			method = "doItemUse",
			cancellable = true
	)
	private void injectUseEntityCallback(CallbackInfo ci, @Local class_1268 hand, @Local class_3966 hitResult, @Local class_1297 entity) {
		class_1269 result = UseEntityCallback.EVENT.invoker().interact(player, player.method_73183(), hand, entity, hitResult);

		if (result != class_1269.field_5811) {
			if (result.method_23665()) {
				class_243 hitVec = hitResult.method_17784().method_1023(entity.method_23317(), entity.method_23318(), entity.method_23321());
				getNetworkHandler().method_52787(class_2824.method_34208(entity, player.method_5715(), hand, hitVec));
			}

			if (result instanceof class_1269.class_9860 success) {
				if (success.comp_2909() == class_1269.class_9861.field_52427) {
					player.method_6104(hand);
				}
			}

			ci.cancel();
		}
	}

	@Inject(
			method = "handleInputEvents",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/client/network/ClientPlayerEntity;isUsingItem()Z",
					ordinal = 0
			)
	)
	private void injectHandleInputEventsForPreAttackCallback(CallbackInfo ci) {
		int attackKeyPressCount = ((KeyBindingAccessor) options.field_1886).fabric_getTimesPressed();

		if (options.field_1886.method_1434() || attackKeyPressCount != 0) {
			attackCancelled = ClientPreAttackCallback.EVENT.invoker().onClientPlayerPreAttack(
					(class_310) (Object) this, player, attackKeyPressCount
			);
		} else {
			attackCancelled = false;
		}
	}

	@Inject(method = "doAttack", at = @At("HEAD"), cancellable = true)
	private void injectDoAttackForCancelling(CallbackInfoReturnable<Boolean> cir) {
		if (attackCancelled) {
			cir.setReturnValue(false);
		}
	}

	@Inject(method = "handleBlockBreaking", at = @At("HEAD"), cancellable = true)
	private void injectHandleBlockBreakingForCancelling(boolean breaking, CallbackInfo ci) {
		if (attackCancelled) {
			if (interactionManager != null) {
				interactionManager.method_2925();
			}

			ci.cancel();
		}
	}
}
