/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.gamerule.widget;

import java.util.List;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.gamerule.v1.rule.EnumRule;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5235;
import net.minecraft.class_5481;

@Environment(EnvType.CLIENT)
public final class EnumRuleWidget<E extends Enum<E>> extends class_5235.class_5400 {
	private final class_4185 buttonWidget;
	private final String rootTranslationKey;

	public EnumRuleWidget(class_5235 gameRuleScreen, class_2561 name, List<class_5481> description, final String ruleName, EnumRule<E> rule, String translationKey) {
		gameRuleScreen.super(description, name);

		// Base translation key needs to be set before the button widget is created.
		this.rootTranslationKey = translationKey;
		this.buttonWidget = class_4185.method_46430(this.getValueText(rule.get()), (buttonWidget) -> {
			rule.cycle();
			buttonWidget.method_25355(this.getValueText(rule.get()));
		}).method_46433(10, 5).method_46437(88, 20).method_46431();

		this.field_25630.add(this.buttonWidget);
	}

	public class_2561 getValueText(E value) {
		final String key = this.rootTranslationKey + "." + value.name().toLowerCase(Locale.ROOT);

		if (class_1074.method_4663(key)) {
			return class_2561.method_43471(key);
		}

		return class_2561.method_43470(value.toString());
	}

	public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
		// FIXME: Param names nightmare
		this.method_29989(matrices, y, x);

		this.buttonWidget.method_1893(x + entryWidth - 89, y);
		this.buttonWidget.method_25394(matrices, mouseX, mouseY, tickDelta);
	}
}
