/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.gamerule;

import java.util.Objects;
import java.util.function.Function;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.impl.gamerule.RuleTypeExtensions;
import net.fabricmc.fabric.impl.gamerule.rpc.FabricGameRuleType;
import net.fabricmc.fabric.impl.gamerule.rpc.FabricTypedRule;
import net.minecraft.class_11844;
import net.minecraft.class_11848;
import net.minecraft.class_12279;
import net.minecraft.class_3542;

@Mixin(class_11844.class_12254.class)
public abstract class GameRuleRpcDispatcherRuleEntryMixin implements FabricTypedRule {
	@Nullable
	@Unique
	private FabricGameRuleType fabricGameRuleType = null;

	@Override
	public @Nullable FabricGameRuleType getFabricType() {
		return fabricGameRuleType;
	}

	@Override
	public void setFabricType(FabricGameRuleType type) {
		this.fabricGameRuleType = Objects.requireNonNull(type);
	}

	@Inject(method = "<init>", at = @At("RETURN"))
	private <T> void updateFabricType(class_12279<T> rule, Object value, CallbackInfo ci) {
		FabricGameRuleType type = ((RuleTypeExtensions) (Object) rule).fabric_getType();

		if (type == null) {
			return;
		}

		this.setFabricType(type);
	}

	@ModifyReturnValue(method = "typedCodec", at = @At("RETURN"))
	private static <T, R extends class_11844.class_12254<T>> MapCodec<R> fabricTypeCodec(MapCodec<? extends class_11844.class_12254<T>> original, class_12279<T> gameRule) {
		MapCodec<? extends class_11844.class_12254<?>> fabricTypedCodec = fabric_createTypedCodec(gameRule);
		//noinspection unchecked
		return (MapCodec<R>) Codec.mapEither(fabricTypedCodec, original).xmap(
				either -> either.map(Function.identity(), Function.identity()),
				typedRule -> ((FabricTypedRule) (Object) typedRule).getFabricType() == null ? (Either) Either.right(typedRule) : (Either) Either.left(typedRule));
	}

	@Unique
	private static <T> class_11844.class_12254<T> fabric_checkType(class_12279<T> gameRule, FabricGameRuleType type, T object) {
		FabricGameRuleType gameRuleType = ((RuleTypeExtensions) (Object) gameRule).fabric_getType();

		if (gameRuleType != type) {
			throw new class_11848("Stated type \"" + type + "\" mismatches with actual type \"" + gameRuleType + "\" of gamerule \"" + gameRule.method_76144() + "\"");
		} else {
			return new class_11844.class_12254<>(gameRule, object);
		}
	}

	@Unique
	private static <T> MapCodec<? extends class_11844.class_12254<T>> fabric_createTypedCodec(class_12279<T> rule) {
		return RecordCodecBuilder.mapCodec((instance) ->
				instance.group(
						class_3542.method_28140(FabricGameRuleType::values).fieldOf("type").forGetter((arg) -> ((RuleTypeExtensions) (Object) arg.comp_5161()).fabric_getType()),
						rule.method_76155().fieldOf("value").forGetter(class_11844.class_12254::comp_5162)
				).apply(instance, (type, object) -> fabric_checkType(rule, type, object)));
	}
}
