/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.gamerule.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.gamerule.v1.CustomGameRuleCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.screens.worldselection.EditGameRulesScreen;
import net.minecraft.world.level.gamerules.GameRule;
import net.minecraft.world.level.gamerules.GameRules;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EditGameRulesScreen.RuleList.class})
public abstract class EditGameRulesScreenRuleListMixin
extends AbstractSelectionList<EditGameRulesScreen.RuleEntry> {
    @Unique
    private final Map<CustomGameRuleCategory, List<EditGameRulesScreen.RuleEntry>> fabricCategories = new HashMap<CustomGameRuleCategory, List<EditGameRulesScreen.RuleEntry>>();

    public EditGameRulesScreenRuleListMixin(Minecraft client, int width, int height, int top, int itemHeight) {
        super(client, width, height, top, itemHeight);
    }

    @Inject(method={"<init>(Lnet/minecraft/client/gui/screens/worldselection/EditGameRulesScreen;Lnet/minecraft/world/level/gamerules/GameRules;)V"}, at={@At(value="TAIL")})
    private void initializeFabricGameruleCategories(EditGameRulesScreen screen, GameRules gameRules, CallbackInfo ci) {
        this.fabricCategories.forEach((category, widgetList) -> {
            EditGameRulesScreen editGameRulesScreen = screen;
            Objects.requireNonNull(editGameRulesScreen);
            this.addEntry((AbstractSelectionList.Entry)new EditGameRulesScreen.CategoryRuleEntry(editGameRulesScreen, category.getName()));
            for (EditGameRulesScreen.RuleEntry widget : widgetList) {
                this.addEntry((AbstractSelectionList.Entry)widget);
            }
        });
    }

    @Inject(method={"lambda$new$1(Ljava/util/Map$Entry;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void ignoreKeysWithCustomCategories(Map.Entry<GameRule<?>, EditGameRulesScreen.RuleEntry> entry, CallbackInfo ci) {
        GameRule<?> rule = entry.getKey();
        CustomGameRuleCategory.getCategory(rule).ifPresent(category -> {
            this.fabricCategories.computeIfAbsent((CustomGameRuleCategory)category, c -> new ArrayList()).add((EditGameRulesScreen.RuleEntry)entry.getValue());
            ci.cancel();
        });
    }
}

