/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.gametest;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.minecraft.class_4519;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FabricGameTestModInitializer
implements ModInitializer {
    private static final String ENTRYPOINT_KEY = "fabric-gametest";
    private static final Map<Class<?>, String> GAME_TEST_IDS = new HashMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricGameTestModInitializer.class);

    public void onInitialize() {
        List entrypointContainers = FabricLoader.getInstance().getEntrypointContainers(ENTRYPOINT_KEY, Object.class);
        for (EntrypointContainer container : entrypointContainers) {
            Class<?> testClass = container.getEntrypoint().getClass();
            String modid = container.getProvider().getMetadata().getId();
            if (GAME_TEST_IDS.containsKey(testClass)) {
                throw new UnsupportedOperationException("Test class (%s) has already been registered with mod (%s)".formatted(testClass.getCanonicalName(), modid));
            }
            GAME_TEST_IDS.put(testClass, modid);
            class_4519.method_36068(testClass);
            LOGGER.debug("Registered test class {} for mod {}", (Object)testClass.getCanonicalName(), (Object)modid);
        }
    }

    public static String getModIdForTestClass(Class<?> testClass) {
        if (!GAME_TEST_IDS.containsKey(testClass)) {
            throw new UnsupportedOperationException("The test class (%s) was not registered using the '%s' entrypoint".formatted(testClass.getCanonicalName(), ENTRYPOINT_KEY));
        }
        return GAME_TEST_IDS.get(testClass);
    }
}

