/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.item.v1;

import net.fabricmc.fabric.impl.item.FabricItemInternals;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_4174;

/**
 * Fabric's version of Item.Settings. Adds additional methods and hooks
 * not found in the original class.
 *
 * <p>To use it, simply replace {@code new Item.Settings()} with
 * {@code new FabricItemSettings()}.
 */
public class FabricItemSettings extends class_1792.class_1793 {
	/**
	 * Sets the equipment slot provider of the item.
	 *
	 * @param equipmentSlotProvider the equipment slot provider
	 * @return this builder
	 */
	public FabricItemSettings equipmentSlot(EquipmentSlotProvider equipmentSlotProvider) {
		FabricItemInternals.computeExtraData(this).equipmentSlot(equipmentSlotProvider);
		return this;
	}

	/**
	 * Sets the custom damage handler of the item.
	 * Note that this is only called on an ItemStack if {@link ItemStack#isDamageable()} returns true.
	 * @see CustomDamageHandler
	 */
	public FabricItemSettings customDamage(CustomDamageHandler handler) {
		FabricItemInternals.computeExtraData(this).customDamage(handler);
		return this;
	}

	// Overrides of vanilla methods

	@Override
	public FabricItemSettings method_19265(class_4174 foodComponent) {
		super.method_19265(foodComponent);
		return this;
	}

	@Override
	public FabricItemSettings method_7889(int maxCount) {
		super.method_7889(maxCount);
		return this;
	}

	@Override
	public FabricItemSettings method_7898(int maxDamage) {
		super.method_7898(maxDamage);
		return this;
	}

	@Override
	public FabricItemSettings method_7895(int maxDamage) {
		super.method_7895(maxDamage);
		return this;
	}

	@Override
	public FabricItemSettings method_7896(class_1792 recipeRemainder) {
		super.method_7896(recipeRemainder);
		return this;
	}

	@Override
	public FabricItemSettings method_7892(class_1761 group) {
		super.method_7892(group);
		return this;
	}

	@Override
	public FabricItemSettings method_7894(class_1814 rarity) {
		super.method_7894(rarity);
		return this;
	}

	@Override
	public FabricItemSettings method_24359() {
		super.method_24359();
		return this;
	}
}
