/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.item.client;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.api.item.v1.FabricItem;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_759;

/**
 * Allow canceling the held item update animation if {@link FabricItem#allowComponentsUpdateAnimation} returns false.
 */
@Mixin(class_759.class)
public class HeldItemRendererMixin {
	@Shadow
	private class_1799 mainHand;

	@Shadow
	private class_1799 offHand;

	@Shadow
	@Final
	private class_310 client;

	@Inject(method = "updateHeldItems", at = @At("HEAD"))
	private void modifyProgressAnimation(CallbackInfo ci) {
		// Modify main hand
		class_1799 newMainStack = client.field_1724.method_6047();

		if (mainHand.method_7909() == newMainStack.method_7909()) {
			if (!mainHand.method_7909().allowComponentsUpdateAnimation(client.field_1724, class_1268.field_5808, mainHand, newMainStack)) {
				mainHand = newMainStack;
			}
		}

		// Modify off hand
		class_1799 newOffStack = client.field_1724.method_6079();

		if (offHand.method_7909() == newOffStack.method_7909()) {
			if (!offHand.method_7909().allowComponentsUpdateAnimation(client.field_1724, class_1268.field_5810, offHand, newOffStack)) {
				offHand = newOffStack;
			}
		}
	}
}
