/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.item;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.fabric.impl.item.VanillaTooltipAppenderOrder;
import net.minecraft.class_10712;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_9299;
import net.minecraft.class_9331;

public final class ComponentTooltipAppenderRegistryImpl {
    private static final List<class_9331<? extends class_9299>> first = new ArrayList<class_9331<? extends class_9299>>();
    private static final List<class_9331<? extends class_9299>> last = new ArrayList<class_9331<? extends class_9299>>();
    private static final Map<class_9331<?>, List<class_9331<? extends class_9299>>> before = new IdentityHashMap();
    private static final Map<class_9331<?>, List<class_9331<? extends class_9299>>> after = new IdentityHashMap();
    private static boolean hasModdedEntries = false;

    public static void addFirst(class_9331<? extends class_9299> componentType) {
        first.add(componentType);
        ComponentTooltipAppenderRegistryImpl.onModified();
    }

    public static void addLast(class_9331<? extends class_9299> componentType) {
        last.add(componentType);
        ComponentTooltipAppenderRegistryImpl.onModified();
    }

    public static void addBefore(class_9331<?> anchor, class_9331<? extends class_9299> componentType) {
        before.computeIfAbsent(anchor, k -> new ArrayList()).add(componentType);
        ComponentTooltipAppenderRegistryImpl.onModified();
    }

    public static void addAfter(class_9331<?> anchor, class_9331<? extends class_9299> componentType) {
        after.computeIfAbsent(anchor, k -> new ArrayList()).add(componentType);
        ComponentTooltipAppenderRegistryImpl.onModified();
    }

    private static void onModified() {
        hasModdedEntries = true;
        VanillaTooltipAppenderOrder.load();
    }

    public static boolean hasModdedEntries() {
        return hasModdedEntries;
    }

    public static void onFirst(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type) {
        HashSet cycleDetector = new HashSet();
        for (class_9331<? extends class_9299> componentType : first) {
            ComponentTooltipAppenderRegistryImpl.appendCustomComponentTooltip(stack, componentType, context, displayComponent, textConsumer, type, cycleDetector);
        }
    }

    public static void onLast(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type) {
        HashSet cycleDetector = new HashSet();
        for (class_9331<? extends class_9299> componentType : last) {
            ComponentTooltipAppenderRegistryImpl.appendCustomComponentTooltip(stack, componentType, context, displayComponent, textConsumer, type, cycleDetector);
        }
    }

    public static void onBefore(class_1799 stack, class_9331<?> componentType, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type, Set<class_9331<?>> cycleDetector) {
        List<class_9331<? extends class_9299>> befores = before.get(componentType);
        if (befores != null) {
            for (class_9331<? extends class_9299> beforeComponentType : befores) {
                ComponentTooltipAppenderRegistryImpl.appendCustomComponentTooltip(stack, beforeComponentType, context, displayComponent, textConsumer, type, cycleDetector);
            }
        }
    }

    public static void onAfter(class_1799 stack, class_9331<?> componentType, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type, Set<class_9331<?>> cycleDetector) {
        List<class_9331<? extends class_9299>> afters = after.get(componentType);
        if (afters != null) {
            for (class_9331<? extends class_9299> afterComponentType : afters) {
                ComponentTooltipAppenderRegistryImpl.appendCustomComponentTooltip(stack, afterComponentType, context, displayComponent, textConsumer, type, cycleDetector);
            }
        }
    }

    private static void appendCustomComponentTooltip(class_1799 stack, class_9331<? extends class_9299> componentType, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type, Set<class_9331<?>> cycleDetector) {
        if (!cycleDetector.add(componentType)) {
            return;
        }
        ComponentTooltipAppenderRegistryImpl.onBefore(stack, componentType, context, displayComponent, textConsumer, type, cycleDetector);
        stack.method_57369(componentType, context, displayComponent, textConsumer, type);
        ComponentTooltipAppenderRegistryImpl.onAfter(stack, componentType, context, displayComponent, textConsumer, type, cycleDetector);
        cycleDetector.remove(componentType);
    }
}

