/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.itemgroup.client;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.client.itemgroup.CreativeGuiExtensions;
import net.fabricmc.fabric.impl.client.itemgroup.FabricCreativeGuiComponents;
import net.fabricmc.fabric.impl.itemgroup.FabricItemGroup;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_481;
import net.minecraft.class_485;
import net.minecraft.class_7706;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_481.class})
public abstract class CreativeInventoryScreenMixin<T extends class_1703>
extends class_485<T>
implements CreativeGuiExtensions {
    @Shadow
    private static class_1761 field_2896;
    private static int fabric_currentPage;

    public CreativeInventoryScreenMixin(T screenHandler, class_1661 playerInventory, class_2561 text) {
        super(screenHandler, playerInventory, text);
    }

    @Shadow
    protected abstract void method_2466(class_1761 var1);

    @Override
    public void fabric_nextPage() {
        if (!CreativeInventoryScreenMixin.fabric_hasGroupForPage(fabric_currentPage + 1)) {
            return;
        }
        ++fabric_currentPage;
        this.fabric_updateSelection();
    }

    @Override
    public void fabric_previousPage() {
        if (fabric_currentPage == 0) {
            return;
        }
        --fabric_currentPage;
        this.fabric_updateSelection();
    }

    @Override
    public boolean fabric_isButtonVisible(FabricCreativeGuiComponents.Type type) {
        return class_7706.method_47335().size() > (Objects.requireNonNull(class_7706.field_42466).comp_1252() ? 14 : 13);
    }

    @Override
    public boolean fabric_isButtonEnabled(FabricCreativeGuiComponents.Type type) {
        if (type == FabricCreativeGuiComponents.Type.NEXT) {
            return CreativeInventoryScreenMixin.fabric_hasGroupForPage(fabric_currentPage + 1);
        }
        if (type == FabricCreativeGuiComponents.Type.PREVIOUS) {
            return fabric_currentPage != 0;
        }
        return false;
    }

    private void fabric_updateSelection() {
        if (!this.fabric_isGroupVisible(field_2896)) {
            class_7706.method_47341().stream().filter(this::fabric_isGroupVisible).min((a, b) -> {
                if (a.method_7752() && !b.method_7752()) {
                    return 1;
                }
                if (!a.method_7752() && b.method_7752()) {
                    return -1;
                }
                return 0;
            }).ifPresent(this::method_2466);
        }
    }

    @Inject(method={"init"}, at={@At(value="RETURN")})
    private void init(CallbackInfo info) {
        fabric_currentPage = CreativeInventoryScreenMixin.fabric_getPage(field_2896);
        int xpos = this.field_2776 + 170;
        int ypos = this.field_2800 + 4;
        this.method_37063((class_364)new FabricCreativeGuiComponents.ItemGroupButtonWidget(xpos + 11, ypos, FabricCreativeGuiComponents.Type.NEXT, this));
        this.method_37063((class_364)new FabricCreativeGuiComponents.ItemGroupButtonWidget(xpos, ypos, FabricCreativeGuiComponents.Type.PREVIOUS, this));
    }

    @Inject(method={"setSelectedTab"}, at={@At(value="HEAD")}, cancellable=true)
    private void setSelectedTab(class_1761 itemGroup, CallbackInfo info) {
        if (!this.fabric_isGroupVisible(itemGroup)) {
            info.cancel();
        }
    }

    @Inject(method={"renderTabTooltipIfHovered"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderTabTooltipIfHovered(class_332 drawContext, class_1761 itemGroup, int mx, int my, CallbackInfoReturnable<Boolean> info) {
        if (!this.fabric_isGroupVisible(itemGroup)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"isClickInTab"}, at={@At(value="HEAD")}, cancellable=true)
    private void isClickInTab(class_1761 itemGroup, double mx, double my, CallbackInfoReturnable<Boolean> info) {
        if (!this.fabric_isGroupVisible(itemGroup)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"renderTabIcon"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderTabIcon(class_332 drawContext, class_1761 itemGroup, CallbackInfo info) {
        if (!this.fabric_isGroupVisible(itemGroup)) {
            info.cancel();
        }
    }

    private boolean fabric_isGroupVisible(class_1761 itemGroup) {
        return fabric_currentPage == CreativeInventoryScreenMixin.fabric_getPage(itemGroup);
    }

    private static int fabric_getPage(class_1761 itemGroup) {
        if (FabricCreativeGuiComponents.COMMON_GROUPS.contains(itemGroup)) {
            return fabric_currentPage;
        }
        FabricItemGroup fabricItemGroup = (FabricItemGroup)itemGroup;
        return fabricItemGroup.getPage();
    }

    private static boolean fabric_hasGroupForPage(int page) {
        return class_7706.method_47335().stream().anyMatch(itemGroup -> CreativeInventoryScreenMixin.fabric_getPage(itemGroup) == page);
    }

    @Override
    public int fabric_currentPage() {
        return fabric_currentPage;
    }

    static {
        fabric_currentPage = 0;
    }
}

