/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.itemgroup.v1;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_7699;
import org.jetbrains.annotations.ApiStatus;

public class FabricItemGroupEntries
implements class_1761.class_7704 {
    private final class_1761.class_8128 context;
    private final List<class_1799> displayStacks;
    private final List<class_1799> searchTabStacks;

    @ApiStatus.Internal
    public FabricItemGroupEntries(class_1761.class_8128 context, List<class_1799> displayStacks, List<class_1799> searchTabStacks) {
        this.context = context;
        this.displayStacks = displayStacks;
        this.searchTabStacks = searchTabStacks;
    }

    public class_1761.class_8128 getContext() {
        return this.context;
    }

    public class_7699 getEnabledFeatures() {
        return this.context.comp_1251();
    }

    public boolean shouldShowOpRestrictedItems() {
        return this.context.comp_1252();
    }

    public List<class_1799> getDisplayStacks() {
        return this.displayStacks;
    }

    public List<class_1799> getSearchTabStacks() {
        return this.searchTabStacks;
    }

    public void method_45417(class_1799 stack, class_1761.class_7705 visibility) {
        if (this.isEnabled(stack)) {
            FabricItemGroupEntries.checkStack(stack);
            switch (visibility) {
                case field_40191: {
                    this.displayStacks.add(stack);
                    this.searchTabStacks.add(stack);
                    break;
                }
                case field_40192: {
                    this.displayStacks.add(stack);
                    break;
                }
                case field_40193: {
                    this.searchTabStacks.add(stack);
                }
            }
        }
    }

    public void prepend(class_1799 stack) {
        this.prepend(stack, class_1761.class_7705.field_40191);
    }

    public void prepend(class_1799 stack, class_1761.class_7705 visibility) {
        if (this.isEnabled(stack)) {
            FabricItemGroupEntries.checkStack(stack);
            switch (visibility) {
                case field_40191: {
                    this.displayStacks.add(0, stack);
                    this.searchTabStacks.add(0, stack);
                    break;
                }
                case field_40192: {
                    this.displayStacks.add(0, stack);
                    break;
                }
                case field_40193: {
                    this.searchTabStacks.add(0, stack);
                }
            }
        }
    }

    public void prepend(class_1935 item) {
        this.prepend(item, class_1761.class_7705.field_40191);
    }

    public void prepend(class_1935 item, class_1761.class_7705 visibility) {
        this.prepend(new class_1799(item), visibility);
    }

    public void addAfter(class_1935 afterLast, class_1799 ... newStack) {
        this.addAfter(afterLast, Arrays.asList(newStack));
    }

    public void addAfter(class_1799 afterLast, class_1799 ... newStack) {
        this.addAfter(afterLast, Arrays.asList(newStack));
    }

    public void addAfter(class_1935 afterLast, class_1935 ... newItem) {
        this.addAfter(afterLast, Arrays.stream(newItem).map(class_1799::new).toList());
    }

    public void addAfter(class_1799 afterLast, class_1935 ... newItem) {
        this.addAfter(afterLast, Arrays.stream(newItem).map(class_1799::new).toList());
    }

    public void addAfter(class_1935 afterLast, Collection<class_1799> newStacks) {
        this.addAfter(afterLast, newStacks, class_1761.class_7705.field_40191);
    }

    public void addAfter(class_1799 afterLast, Collection<class_1799> newStacks) {
        this.addAfter(afterLast, newStacks, class_1761.class_7705.field_40191);
    }

    public void addAfter(class_1935 afterLast, Collection<class_1799> newStacks, class_1761.class_7705 visibility) {
        if ((newStacks = this.getEnabledStacks(newStacks)).isEmpty()) {
            return;
        }
        switch (visibility) {
            case field_40191: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.displayStacks);
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.searchTabStacks);
                break;
            }
            case field_40192: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.displayStacks);
                break;
            }
            case field_40193: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.searchTabStacks);
            }
        }
    }

    public void addAfter(class_1799 afterLast, Collection<class_1799> newStacks, class_1761.class_7705 visibility) {
        if ((newStacks = this.getEnabledStacks(newStacks)).isEmpty()) {
            return;
        }
        switch (visibility) {
            case field_40191: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.displayStacks);
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.searchTabStacks);
                break;
            }
            case field_40192: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.displayStacks);
                break;
            }
            case field_40193: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.searchTabStacks);
            }
        }
    }

    public void addAfter(Predicate<class_1799> afterLast, Collection<class_1799> newStacks, class_1761.class_7705 visibility) {
        if ((newStacks = this.getEnabledStacks(newStacks)).isEmpty()) {
            return;
        }
        switch (visibility) {
            case field_40191: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.displayStacks);
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.searchTabStacks);
                break;
            }
            case field_40192: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.displayStacks);
                break;
            }
            case field_40193: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.searchTabStacks);
            }
        }
    }

    public void addBefore(class_1935 beforeFirst, class_1799 ... newStack) {
        this.addBefore(beforeFirst, Arrays.asList(newStack));
    }

    public void addBefore(class_1799 beforeFirst, class_1799 ... newStack) {
        this.addBefore(beforeFirst, Arrays.asList(newStack));
    }

    public void addBefore(class_1935 beforeFirst, class_1935 ... newItem) {
        this.addBefore(beforeFirst, Arrays.stream(newItem).map(class_1799::new).toList());
    }

    public void addBefore(class_1799 beforeFirst, class_1935 ... newItem) {
        this.addBefore(beforeFirst, Arrays.stream(newItem).map(class_1799::new).toList());
    }

    public void addBefore(class_1935 beforeFirst, Collection<class_1799> newStacks) {
        this.addBefore(beforeFirst, newStacks, class_1761.class_7705.field_40191);
    }

    public void addBefore(class_1799 beforeFirst, Collection<class_1799> newStacks) {
        this.addBefore(beforeFirst, newStacks, class_1761.class_7705.field_40191);
    }

    public void addBefore(class_1935 beforeFirst, Collection<class_1799> newStacks, class_1761.class_7705 visibility) {
        if ((newStacks = this.getEnabledStacks(newStacks)).isEmpty()) {
            return;
        }
        switch (visibility) {
            case field_40191: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.displayStacks);
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.searchTabStacks);
                break;
            }
            case field_40192: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.displayStacks);
                break;
            }
            case field_40193: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.searchTabStacks);
            }
        }
    }

    public void addBefore(class_1799 beforeFirst, Collection<class_1799> newStacks, class_1761.class_7705 visibility) {
        if ((newStacks = this.getEnabledStacks(newStacks)).isEmpty()) {
            return;
        }
        switch (visibility) {
            case field_40191: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.displayStacks);
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.searchTabStacks);
                break;
            }
            case field_40192: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.displayStacks);
                break;
            }
            case field_40193: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.searchTabStacks);
            }
        }
    }

    public void addBefore(Predicate<class_1799> beforeFirst, Collection<class_1799> newStacks, class_1761.class_7705 visibility) {
        if ((newStacks = this.getEnabledStacks(newStacks)).isEmpty()) {
            return;
        }
        switch (visibility) {
            case field_40191: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.displayStacks);
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.searchTabStacks);
                break;
            }
            case field_40192: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.displayStacks);
                break;
            }
            case field_40193: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.searchTabStacks);
            }
        }
    }

    private boolean isEnabled(class_1799 stack) {
        return stack.method_7909().method_45382(this.getEnabledFeatures());
    }

    private Collection<class_1799> getEnabledStacks(Collection<class_1799> newStacks) {
        if (newStacks.stream().allMatch(this::isEnabled)) {
            return newStacks;
        }
        return newStacks.stream().filter(this::isEnabled).toList();
    }

    private static void addBefore(Predicate<class_1799> predicate, Collection<class_1799> newStacks, List<class_1799> addTo) {
        FabricItemGroupEntries.checkStacks(newStacks);
        for (int i = 0; i < addTo.size(); ++i) {
            if (!predicate.test(addTo.get(i))) continue;
            addTo.subList(i, i).addAll(newStacks);
            return;
        }
        addTo.addAll(newStacks);
    }

    private static void addAfter(Predicate<class_1799> predicate, Collection<class_1799> newStacks, List<class_1799> addTo) {
        FabricItemGroupEntries.checkStacks(newStacks);
        for (int i = addTo.size() - 1; i >= 0; --i) {
            if (!predicate.test(addTo.get(i))) continue;
            addTo.subList(i + 1, i + 1).addAll(newStacks);
            return;
        }
        addTo.addAll(newStacks);
    }

    private static void addBefore(class_1799 anchor, Collection<class_1799> newStacks, List<class_1799> addTo) {
        FabricItemGroupEntries.checkStacks(newStacks);
        for (int i = 0; i < addTo.size(); ++i) {
            if (!class_1799.method_31577((class_1799)anchor, (class_1799)addTo.get(i))) continue;
            addTo.subList(i, i).addAll(newStacks);
            return;
        }
        addTo.addAll(newStacks);
    }

    private static void addAfter(class_1799 anchor, Collection<class_1799> newStacks, List<class_1799> addTo) {
        FabricItemGroupEntries.checkStacks(newStacks);
        for (int i = addTo.size() - 1; i >= 0; --i) {
            if (!class_1799.method_31577((class_1799)anchor, (class_1799)addTo.get(i))) continue;
            addTo.subList(i + 1, i + 1).addAll(newStacks);
            return;
        }
        addTo.addAll(newStacks);
    }

    private static void addBefore(class_1935 anchor, Collection<class_1799> newStacks, List<class_1799> addTo) {
        FabricItemGroupEntries.checkStacks(newStacks);
        class_1792 anchorItem = anchor.method_8389();
        for (int i = 0; i < addTo.size(); ++i) {
            if (!addTo.get(i).method_31574(anchorItem)) continue;
            addTo.subList(i, i).addAll(newStacks);
            return;
        }
        addTo.addAll(newStacks);
    }

    private static void addAfter(class_1935 anchor, Collection<class_1799> newStacks, List<class_1799> addTo) {
        FabricItemGroupEntries.checkStacks(newStacks);
        class_1792 anchorItem = anchor.method_8389();
        for (int i = addTo.size() - 1; i >= 0; --i) {
            if (!addTo.get(i).method_31574(anchorItem)) continue;
            addTo.subList(i + 1, i + 1).addAll(newStacks);
            return;
        }
        addTo.addAll(newStacks);
    }

    private static void checkStacks(Collection<class_1799> stacks) {
        for (class_1799 stack : stacks) {
            FabricItemGroupEntries.checkStack(stack);
        }
    }

    private static void checkStack(class_1799 stack) {
        if (stack.method_7960()) {
            throw new IllegalArgumentException("Cannot add empty stack");
        }
        if (stack.method_7947() != 1) {
            throw new IllegalArgumentException("Stack size must be exactly 1 for stack: " + String.valueOf(stack));
        }
    }
}

