/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.itemgroup.client;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.itemgroup.v1.FabricCreativeInventoryScreen;
import net.fabricmc.fabric.impl.client.itemgroup.FabricCreativeGuiComponents;
import net.fabricmc.fabric.impl.itemgroup.FabricItemGroupImpl;
import net.minecraft.class_11908;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_7706;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_481.class})
public abstract class CreativeModeInventoryScreenMixin
extends class_465<class_481.class_483>
implements FabricCreativeInventoryScreen {
    @Shadow
    private static class_1761 field_2896;
    @Unique
    private static int currentPage;

    public CreativeModeInventoryScreenMixin(class_481.class_483 screenHandler, class_1661 playerInventory, class_2561 text) {
        super((class_1703)screenHandler, playerInventory, text);
    }

    @Shadow
    protected abstract void method_2466(class_1761 var1);

    @Unique
    private void updateSelection() {
        if (!this.isGroupVisible(field_2896)) {
            class_7706.method_47341().stream().filter(this::isGroupVisible).min((a, b) -> Boolean.compare(a.method_7752(), b.method_7752())).ifPresent(this::method_2466);
        }
    }

    @Inject(method={"method_25426()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_342;method_1868(I)V", shift=At.Shift.AFTER)})
    private void init(CallbackInfo info) {
        currentPage = this.getPage(field_2896);
        int xpos = this.field_2776 + 171;
        int ypos = this.field_2800 + 4;
        class_481 self = (class_481)this;
        this.method_37063((class_364)new FabricCreativeGuiComponents.ItemGroupButtonWidget(xpos + 10, ypos, FabricCreativeGuiComponents.Type.NEXT, self));
        this.method_37063((class_364)new FabricCreativeGuiComponents.ItemGroupButtonWidget(xpos, ypos, FabricCreativeGuiComponents.Type.PREVIOUS, self));
    }

    @Inject(method={"method_2466(Lnet/minecraft/class_1761;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void setSelectedTab(class_1761 itemGroup, CallbackInfo info) {
        if (!this.isGroupVisible(itemGroup)) {
            info.cancel();
        }
    }

    @Inject(method={"method_2471(Lnet/minecraft/class_332;Lnet/minecraft/class_1761;II)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderTabTooltipIfHovered(class_332 drawContext, class_1761 itemGroup, int mx, int my, CallbackInfoReturnable<Boolean> info) {
        if (!this.isGroupVisible(itemGroup)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"method_2463(Lnet/minecraft/class_1761;DD)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void isClickInTab(class_1761 itemGroup, double mx, double my, CallbackInfoReturnable<Boolean> info) {
        if (!this.isGroupVisible(itemGroup)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"method_2468(Lnet/minecraft/class_332;Lnet/minecraft/class_1761;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderTabIcon(class_332 drawContext, class_1761 itemGroup, CallbackInfo info) {
        if (!this.isGroupVisible(itemGroup)) {
            info.cancel();
        }
    }

    @Inject(method={"method_25404(Lnet/minecraft/class_11908;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void keyPressed(class_11908 context, CallbackInfoReturnable<Boolean> cir) {
        if (context.comp_4795() == 266) {
            if (this.switchToPreviousPage()) {
                cir.setReturnValue((Object)true);
            }
        } else if (context.comp_4795() == 267 && this.switchToNextPage()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    private boolean isGroupVisible(class_1761 itemGroup) {
        return itemGroup.method_47311() && currentPage == this.getPage(itemGroup);
    }

    @Override
    public int getPage(class_1761 itemGroup) {
        if (FabricCreativeGuiComponents.COMMON_GROUPS.contains(itemGroup)) {
            return currentPage;
        }
        FabricItemGroupImpl fabricItemGroup = (FabricItemGroupImpl)itemGroup;
        return fabricItemGroup.fabric_getPage();
    }

    @Unique
    private boolean hasGroupForPage(int page) {
        return class_7706.method_47335().stream().anyMatch(itemGroup -> this.getPage((class_1761)itemGroup) == page);
    }

    @Override
    public boolean switchToPage(int page) {
        if (!this.hasGroupForPage(page)) {
            return false;
        }
        if (currentPage == page) {
            return false;
        }
        currentPage = page;
        this.updateSelection();
        return true;
    }

    @Override
    public int getCurrentPage() {
        return currentPage;
    }

    @Override
    public int getPageCount() {
        return FabricCreativeGuiComponents.getPageCount();
    }

    @Override
    public List<class_1761> getItemGroupsOnPage(int page) {
        return class_7706.method_47335().stream().filter(itemGroup -> this.getPage((class_1761)itemGroup) == page).sorted(Comparator.comparing(class_1761::method_47309).thenComparingInt(class_1761::method_7743)).sorted((a, b) -> Boolean.compare(a.method_7752(), b.method_7752())).toList();
    }

    @Override
    public boolean hasAdditionalPages() {
        return class_7706.method_47335().size() > (Objects.requireNonNull(class_7706.field_42466).comp_1252() ? 14 : 13);
    }

    @Override
    public class_1761 getSelectedItemGroup() {
        return field_2896;
    }

    @Override
    public boolean setSelectedItemGroup(class_1761 itemGroup) {
        Objects.requireNonNull(itemGroup, "itemGroup");
        if (field_2896 == itemGroup) {
            return false;
        }
        if (currentPage != this.getPage(itemGroup) && !this.switchToPage(this.getPage(itemGroup))) {
            return false;
        }
        this.method_2466(itemGroup);
        return true;
    }

    static {
        currentPage = 0;
    }
}

