/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.itemgroup;

import static net.minecraft.class_7706.field_40195;
import static net.minecraft.class_7706.field_41059;
import static net.minecraft.class_7706.field_40202;
import static net.minecraft.class_7706.field_41061;
import static net.minecraft.class_7706.field_40197;
import static net.minecraft.class_7706.field_40199;
import static net.minecraft.class_7706.field_41062;
import static net.minecraft.class_7706.field_40206;
import static net.minecraft.class_7706.field_40743;
import static net.minecraft.class_7706.field_41063;
import static net.minecraft.class_7706.field_40198;
import static net.minecraft.class_7706.field_40200;
import static net.minecraft.class_7706.field_40205;
import static net.minecraft.class_7706.field_41060;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.impl.itemgroup.FabricItemGroupImpl;
import net.minecraft.class_1761;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

@Mixin(class_7706.class)
public class CreativeModeTabsMixin {
	@Unique
	private static final int TABS_PER_PAGE = FabricItemGroupImpl.TABS_PER_PAGE;

	@Inject(method = "validate", at = @At("HEAD"), cancellable = true)
	private static void deferDuplicateCheck(CallbackInfo ci) {
		/*
		 * Defer the duplication checks to when fabric performs them (see mixin below).
		 * It is preserved just in case, but fabric's pagination logic should prevent any from happening anyway.
		 */
		ci.cancel();
	}

	@Inject(method = "buildAllTabContents", at = @At("TAIL"))
	private static void paginateGroups(CallbackInfo ci) {
		final List<class_5321<class_1761>> vanillaGroups = List.of(field_40195, field_41059, field_40743, field_40197, field_40198, field_40199, field_40200, field_41060, field_40202, field_41061, field_41062, field_40205, field_41063, field_40206);

		int count = 0;

		Comparator<class_6880.class_6883<class_1761>> entryComparator = (e1, e2) -> {
			// Non-displayable groups should come last for proper pagination
			int displayCompare = Boolean.compare(e1.comp_349().method_47311(), e2.comp_349().method_47311());

			if (displayCompare != 0) {
				return -displayCompare;
			} else {
				// Ensure a deterministic order
				return compareNamespaceFirst(e1.method_40237().method_29177(), e2.method_40237().method_29177());
			}
		};
		final List<class_6880.class_6883<class_1761>> sortedItemGroups = class_7923.field_44687.method_42017()
				.sorted(entryComparator)
				.toList();

		for (class_6880.class_6883<class_1761> reference : sortedItemGroups) {
			final class_1761 itemGroup = reference.comp_349();
			final FabricItemGroupImpl fabricItemGroup = (FabricItemGroupImpl) itemGroup;

			if (vanillaGroups.contains(reference.method_40237())) {
				// Vanilla group goes on the first page.
				fabricItemGroup.fabric_setPage(0);
				continue;
			}

			final CreativeModeTabAccessor itemGroupAccessor = (CreativeModeTabAccessor) itemGroup;
			fabricItemGroup.fabric_setPage((count / TABS_PER_PAGE) + 1);
			int pageIndex = count % TABS_PER_PAGE;
			class_1761.class_7915 row = pageIndex < (TABS_PER_PAGE / 2) ? class_1761.class_7915.field_41049 : class_1761.class_7915.field_41050;
			itemGroupAccessor.setRow(row);
			itemGroupAccessor.setColumn(row == class_1761.class_7915.field_41049 ? pageIndex % TABS_PER_PAGE : (pageIndex - TABS_PER_PAGE / 2) % (TABS_PER_PAGE));

			count++;
		}

		// Overlapping group detection logic, with support for pages.
		record ItemGroupPosition(class_1761.class_7915 row, int column, int page) { }
		var map = new HashMap<ItemGroupPosition, String>();

		for (class_5321<class_1761> registryKey : class_7923.field_44687.method_42021()) {
			final class_1761 itemGroup = class_7923.field_44687.method_31140(registryKey);
			final FabricItemGroupImpl fabricItemGroup = (FabricItemGroupImpl) itemGroup;
			final String displayName = itemGroup.method_7737().getString();
			final var position = new ItemGroupPosition(itemGroup.method_47309(), itemGroup.method_7743(), fabricItemGroup.fabric_getPage());
			final String existingName = map.put(position, displayName);

			if (existingName != null) {
				throw new IllegalArgumentException("Duplicate position: (%s) for item groups %s vs %s".formatted(position, displayName, existingName));
			}
		}
	}

	// Identifier#compareTo checks the path first, but we want to check the namespace first so that groups added by the
	// same mod appear next to each other.
	@Unique
	private static int compareNamespaceFirst(class_2960 a, class_2960 b) {
		int c = a.method_12836().compareTo(b.method_12836());

		if (c != 0) {
			return c;
		}

		return a.method_12832().compareTo(b.method_12832());
	}
}
