/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.itemgroup.client;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.client.itemgroup.v1.FabricCreativeInventoryScreen;
import net.fabricmc.fabric.impl.client.itemgroup.FabricCreativeGuiComponents;
import net.fabricmc.fabric.impl.itemgroup.FabricItemGroupImpl;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CreativeModeInventoryScreen.class})
public abstract class CreativeModeInventoryScreenMixin
extends AbstractContainerScreen<CreativeModeInventoryScreen.ItemPickerMenu>
implements FabricCreativeInventoryScreen {
    @Shadow
    private static CreativeModeTab selectedTab;
    @Unique
    private static int currentPage;

    public CreativeModeInventoryScreenMixin(CreativeModeInventoryScreen.ItemPickerMenu screenHandler, Inventory playerInventory, Component text) {
        super((AbstractContainerMenu)screenHandler, playerInventory, text);
    }

    @Shadow
    protected abstract void selectTab(CreativeModeTab var1);

    @Unique
    private void updateSelection() {
        if (!this.isGroupVisible(selectedTab)) {
            CreativeModeTabs.allTabs().stream().filter(this::isGroupVisible).min((a, b) -> Boolean.compare(a.isAlignedRight(), b.isAlignedRight())).ifPresent(this::selectTab);
        }
    }

    @Inject(method={"init"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;setTextColor(I)V", shift=At.Shift.AFTER)})
    private void init(CallbackInfo info) {
        currentPage = this.getPage(selectedTab);
        int xpos = this.leftPos + 171;
        int ypos = this.topPos + 4;
        CreativeModeInventoryScreen self = (CreativeModeInventoryScreen)this;
        this.addRenderableWidget((GuiEventListener)new FabricCreativeGuiComponents.ItemGroupButtonWidget(xpos + 10, ypos, FabricCreativeGuiComponents.Type.NEXT, self));
        this.addRenderableWidget((GuiEventListener)new FabricCreativeGuiComponents.ItemGroupButtonWidget(xpos, ypos, FabricCreativeGuiComponents.Type.PREVIOUS, self));
    }

    @Inject(method={"selectTab"}, at={@At(value="HEAD")}, cancellable=true)
    private void setSelectedTab(CreativeModeTab itemGroup, CallbackInfo info) {
        if (!this.isGroupVisible(itemGroup)) {
            info.cancel();
        }
    }

    @Inject(method={"checkTabHovering"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderTabTooltipIfHovered(GuiGraphics drawContext, CreativeModeTab itemGroup, int mx, int my, CallbackInfoReturnable<Boolean> info) {
        if (!this.isGroupVisible(itemGroup)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"checkTabClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void isClickInTab(CreativeModeTab itemGroup, double mx, double my, CallbackInfoReturnable<Boolean> info) {
        if (!this.isGroupVisible(itemGroup)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"renderTabButton"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderTabIcon(GuiGraphics guiGraphics, int i, int j, CreativeModeTab itemGroup, CallbackInfo info) {
        if (!this.isGroupVisible(itemGroup)) {
            info.cancel();
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void keyPressed(KeyEvent context, CallbackInfoReturnable<Boolean> cir) {
        if (context.key() == 266) {
            if (this.switchToPreviousPage()) {
                cir.setReturnValue((Object)true);
            }
        } else if (context.key() == 267 && this.switchToNextPage()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    private boolean isGroupVisible(CreativeModeTab itemGroup) {
        return itemGroup.shouldDisplay() && currentPage == this.getPage(itemGroup);
    }

    @Override
    public int getPage(CreativeModeTab itemGroup) {
        if (FabricCreativeGuiComponents.COMMON_GROUPS.contains(itemGroup)) {
            return currentPage;
        }
        FabricItemGroupImpl fabricItemGroup = (FabricItemGroupImpl)itemGroup;
        return fabricItemGroup.fabric_getPage();
    }

    @Unique
    private boolean hasGroupForPage(int page) {
        return CreativeModeTabs.tabs().stream().anyMatch(itemGroup -> this.getPage((CreativeModeTab)itemGroup) == page);
    }

    @Override
    public boolean switchToPage(int page) {
        if (!this.hasGroupForPage(page)) {
            return false;
        }
        if (currentPage == page) {
            return false;
        }
        currentPage = page;
        this.updateSelection();
        return true;
    }

    @Override
    public int getCurrentPage() {
        return currentPage;
    }

    @Override
    public int getPageCount() {
        return FabricCreativeGuiComponents.getPageCount();
    }

    @Override
    public List<CreativeModeTab> getItemGroupsOnPage(int page) {
        return CreativeModeTabs.tabs().stream().filter(itemGroup -> this.getPage((CreativeModeTab)itemGroup) == page).sorted(Comparator.comparing(CreativeModeTab::row).thenComparingInt(CreativeModeTab::column)).sorted((a, b) -> Boolean.compare(a.isAlignedRight(), b.isAlignedRight())).toList();
    }

    @Override
    public boolean hasAdditionalPages() {
        return CreativeModeTabs.tabs().size() > (Objects.requireNonNull(CreativeModeTabs.CACHED_PARAMETERS).hasPermissions() ? 14 : 13);
    }

    @Override
    public CreativeModeTab getSelectedItemGroup() {
        return selectedTab;
    }

    @Override
    public boolean setSelectedItemGroup(CreativeModeTab itemGroup) {
        Objects.requireNonNull(itemGroup, "itemGroup");
        if (selectedTab == itemGroup) {
            return false;
        }
        if (currentPage != this.getPage(itemGroup) && !this.switchToPage(this.getPage(itemGroup))) {
            return false;
        }
        this.selectTab(itemGroup);
        return true;
    }

    static {
        currentPage = 0;
    }
}

