/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.event.lifecycle;

import static net.minecraft.class_3194.field_44856;
import static net.minecraft.class_3194.field_13877;
import static net.minecraft.class_3194.field_44855;
import static net.minecraft.class_3194.field_19334;

import java.util.concurrent.Executor;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.impl.event.lifecycle.ChunkLevelTypeEventTracker;
import net.minecraft.class_1923;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_3193;
import net.minecraft.class_3194;
import net.minecraft.class_3218;
import net.minecraft.class_3898;
import net.minecraft.class_5539;
import net.minecraft.class_8563;
import net.minecraft.class_9761;

@Mixin(class_3193.class)
public abstract class ChunkHolderMixin extends class_9761 implements ChunkLevelTypeEventTracker {
	@Shadow
	@Final
	private class_5539 levelHeightAccessor;

	@Shadow
	private int oldTicketLevel;

	@Unique
	private static final class_3194[] fabric_CHUNK_LEVEL_TYPES = class_3194.values(); // values() clones the internal array each call, so cache the return

	@Unique
	private class_3194 fabric_currentEventLevelType = field_19334;

	private ChunkHolderMixin(class_1923 pos) {
		super(pos);
	}

	/**
	 * Handles INACCESSIBLE -> FULL for chunks that are immediately loaded and available. {@link ChunkStatusTasksMixin} handles the rest.
	 */
	@Inject(method = "updateFutures", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/level/ChunkHolder;addSaveDependency(Ljava/util/concurrent/CompletableFuture;)V", shift = At.Shift.AFTER, ordinal = 0))
	private void updateFutures$inaccessibleToFull(class_3898 chunkLoadingManager, Executor executor, CallbackInfo ci) {
		if (this.method_60457(class_2806.field_12803) instanceof class_2818 && this.fabric_currentEventLevelType == field_19334) { // prevent duplicate events with ChunkStatusTasksMixin
			ServerChunkEvents.CHUNK_LEVEL_TYPE_CHANGE.invoker().onChunkLevelTypeChange((class_3218) levelHeightAccessor, (class_2818) this.method_60457(class_2806.field_12803), field_19334, field_44855);
			this.fabric_currentEventLevelType = field_44855;
		}
	}

	/**
	 * Handles FULL -> BLOCK_TICKING.
	 */
	@Inject(method = "updateFutures", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/level/ChunkHolder;addSaveDependency(Ljava/util/concurrent/CompletableFuture;)V", shift = At.Shift.AFTER, ordinal = 1))
	private void updateFutures$fullToBlockTicking(class_3898 chunkLoadingManager, Executor executor, CallbackInfo ci) {
		if (fabric_currentEventLevelType == field_44855) { // if INACCESSIBLE->FULL did not fire immediately, then ChunkStatusTasksMixin will handle this later.
			ServerChunkEvents.CHUNK_LEVEL_TYPE_CHANGE.invoker().onChunkLevelTypeChange((class_3218) levelHeightAccessor, (class_2818) this.method_60457(class_2806.field_12803), field_44855, field_44856);
			this.fabric_currentEventLevelType = field_44856;
		}
	}

	/**
	 * Handles BLOCK_TICKING -> ENTITY_TICKING.
	 */
	@Inject(method = "updateFutures", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/level/ChunkHolder;addSaveDependency(Ljava/util/concurrent/CompletableFuture;)V", shift = At.Shift.AFTER, ordinal = 2))
	private void updateFutures$blockTickingToEntityTicking(class_3898 chunkLoadingManager, Executor executor, CallbackInfo ci) {
		if (fabric_currentEventLevelType == field_44856) { // if INACCESSIBLE->FULL->BLOCK_TICKING did not fire immediately, then ChunkStatusTasksMixin will handle this later.
			ServerChunkEvents.CHUNK_LEVEL_TYPE_CHANGE.invoker().onChunkLevelTypeChange((class_3218) levelHeightAccessor, (class_2818) this.method_60457(class_2806.field_12803), field_44856, field_13877);
			this.fabric_currentEventLevelType = field_13877;
		}
	}

	/**
	 * Really means increase level (chunk load type demotion). Fire right before onChunkStatusChange() is called.
	 */
	@Inject(method = "demoteFullChunk", at = @At("HEAD"))
	private void decreaseLevel(class_3898 chunkLoadingManager, class_3194 target, CallbackInfo ci) {
		class_3194 previous = class_8563.method_51830(this.oldTicketLevel);
		class_3218 serverWorld = (class_3218) levelHeightAccessor;

		for (int i = previous.ordinal(); i > target.ordinal(); i--) {
			class_3194 oldLevelType = fabric_CHUNK_LEVEL_TYPES[i];
			class_3194 newLevelType = fabric_CHUNK_LEVEL_TYPES[i-1];
			if (this.fabric_currentEventLevelType.method_14014(oldLevelType)) { // if a promotion event got cancelled or never finished, then do _not_ fire an equivalent demotion event
				ServerChunkEvents.CHUNK_LEVEL_TYPE_CHANGE.invoker().onChunkLevelTypeChange(serverWorld, (class_2818) this.method_60457(class_2806.field_12803), oldLevelType, newLevelType);
				this.fabric_currentEventLevelType = newLevelType;
			}
		}
	}

	@Override
	public void fabric_setCurrentEventLevelType(class_3194 levelType) {
		this.fabric_currentEventLevelType = levelType;
	}

	@Override
	public class_3194 fabric_getCurrentEventLevelType() {
		return this.fabric_currentEventLevelType;
	}
}
