/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.event.lifecycle.v1;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_2818;
import net.minecraft.class_3194;
import net.minecraft.class_3218;

public final class ServerChunkEvents {
    public static final Event<Load> CHUNK_LOAD = EventFactory.createArrayBacked(Load.class, callbacks -> (serverWorld, chunk) -> {
        for (Load callback : callbacks) {
            callback.onChunkLoad(serverWorld, chunk);
        }
    });
    public static final Event<Generate> CHUNK_GENERATE = EventFactory.createArrayBacked(Generate.class, callbacks -> (serverWorld, chunk) -> {
        for (Generate callback : callbacks) {
            callback.onChunkGenerate(serverWorld, chunk);
        }
    });
    public static final Event<Unload> CHUNK_UNLOAD = EventFactory.createArrayBacked(Unload.class, callbacks -> (serverWorld, chunk) -> {
        for (Unload callback : callbacks) {
            callback.onChunkUnload(serverWorld, chunk);
        }
    });
    public static final Event<LevelTypeChange> CHUNK_LEVEL_TYPE_CHANGE = EventFactory.createArrayBacked(LevelTypeChange.class, (world, chunk, oldLevelType, newLevelType) -> {}, callbacks -> (serverWorld, chunk, oldLevelType, newLevelType) -> {
        for (LevelTypeChange callback : callbacks) {
            callback.onChunkLevelTypeChange(serverWorld, chunk, oldLevelType, newLevelType);
        }
    });

    private ServerChunkEvents() {
    }

    @FunctionalInterface
    public static interface LevelTypeChange {
        public void onChunkLevelTypeChange(class_3218 var1, class_2818 var2, class_3194 var3, class_3194 var4);
    }

    @FunctionalInterface
    public static interface Unload {
        public void onChunkUnload(class_3218 var1, class_2818 var2);
    }

    @FunctionalInterface
    public static interface Generate {
        public void onChunkGenerate(class_3218 var1, class_2818 var2);
    }

    @FunctionalInterface
    public static interface Load {
        public void onChunkLoad(class_3218 var1, class_2818 var2);
    }
}

