/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.event.lifecycle.client;

import java.util.Map;
import java.util.function.Consumer;

import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.minecraft.class_1923;
import net.minecraft.class_2540;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_631;
import net.minecraft.class_638;
import net.minecraft.class_6603;

@Mixin(class_631.class)
public abstract class ClientChunkCacheMixin {
	@Final
	@Shadow
	class_638 level;

	@Inject(method = "replaceWithPacketData", at = @At("TAIL"))
	private void onChunkLoad(int x, int z, class_2540 packetByteBuf, Map<class_2902.class_2903, long[]> highmap, Consumer<class_6603.class_6605> consumer, CallbackInfoReturnable<class_2818> info) {
		ClientChunkEvents.CHUNK_LOAD.invoker().onChunkLoad(this.level, info.getReturnValue());
	}

	@Inject(method = "replaceWithPacketData", at = @At(value = "NEW", target = "net/minecraft/world/level/chunk/LevelChunk", shift = At.Shift.BEFORE))
	private void onChunkUnload(int x, int z, class_2540 buf, Map<class_2902.class_2903, long[]> highmap, Consumer<class_6603.class_6605> consumer, CallbackInfoReturnable<class_2818> info, @Local class_2818 worldChunk) {
		if (worldChunk != null) {
			ClientChunkEvents.CHUNK_UNLOAD.invoker().onChunkUnload(this.level, worldChunk);
		}
	}

	@Inject(method = "drop", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/multiplayer/ClientChunkCache$Storage;drop(ILnet/minecraft/world/level/chunk/LevelChunk;)V"))
	private void onChunkUnload(class_1923 pos, CallbackInfo ci, @Local class_2818 chunk) {
		ClientChunkEvents.CHUNK_UNLOAD.invoker().onChunkUnload(this.level, chunk);
	}

	@Inject(
			method = "updateViewRadius",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/client/multiplayer/ClientChunkCache$Storage;inRange(II)Z"
			)
	)
	private void onUpdateLoadDistance(int loadDistance, CallbackInfo ci, @Local class_631.class_3681 clientChunkMap, @Local class_2818 oldChunk, @Local class_1923 chunkPos) {
		if (!clientChunkMap.method_16034(chunkPos.field_9181, chunkPos.field_9180)) {
			ClientChunkEvents.CHUNK_UNLOAD.invoker().onChunkUnload(this.level, oldChunk);
		}
	}
}
