/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.event.lifecycle;

import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.impl.event.lifecycle.ChunkLevelTypeEventTracker;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkHolder.class})
public abstract class ChunkHolderMixin
extends GenerationChunkHolder
implements ChunkLevelTypeEventTracker {
    @Shadow
    @Final
    private LevelHeightAccessor levelHeightAccessor;
    @Shadow
    private int oldTicketLevel;
    @Unique
    private static final FullChunkStatus[] fabric_CHUNK_LEVEL_TYPES = FullChunkStatus.values();
    @Unique
    private FullChunkStatus fabric_currentEventLevelType = FullChunkStatus.INACCESSIBLE;

    private ChunkHolderMixin(ChunkPos pos) {
        super(pos);
    }

    @Inject(method={"updateFutures"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkHolder;addSaveDependency(Ljava/util/concurrent/CompletableFuture;)V", shift=At.Shift.AFTER, ordinal=0)})
    private void updateFutures$inaccessibleToFull(ChunkMap chunkLoadingManager, Executor executor, CallbackInfo ci) {
        if (this.getChunkIfPresentUnchecked(ChunkStatus.FULL) instanceof LevelChunk && this.fabric_currentEventLevelType == FullChunkStatus.INACCESSIBLE) {
            ((ServerChunkEvents.LevelTypeChange)ServerChunkEvents.CHUNK_LEVEL_TYPE_CHANGE.invoker()).onChunkLevelTypeChange((ServerLevel)this.levelHeightAccessor, (LevelChunk)this.getChunkIfPresentUnchecked(ChunkStatus.FULL), FullChunkStatus.INACCESSIBLE, FullChunkStatus.FULL);
            this.fabric_currentEventLevelType = FullChunkStatus.FULL;
        }
    }

    @Inject(method={"updateFutures"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkHolder;addSaveDependency(Ljava/util/concurrent/CompletableFuture;)V", shift=At.Shift.AFTER, ordinal=1)})
    private void updateFutures$fullToBlockTicking(ChunkMap chunkLoadingManager, Executor executor, CallbackInfo ci) {
        if (this.fabric_currentEventLevelType == FullChunkStatus.FULL) {
            ((ServerChunkEvents.LevelTypeChange)ServerChunkEvents.CHUNK_LEVEL_TYPE_CHANGE.invoker()).onChunkLevelTypeChange((ServerLevel)this.levelHeightAccessor, (LevelChunk)this.getChunkIfPresentUnchecked(ChunkStatus.FULL), FullChunkStatus.FULL, FullChunkStatus.BLOCK_TICKING);
            this.fabric_currentEventLevelType = FullChunkStatus.BLOCK_TICKING;
        }
    }

    @Inject(method={"updateFutures"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkHolder;addSaveDependency(Ljava/util/concurrent/CompletableFuture;)V", shift=At.Shift.AFTER, ordinal=2)})
    private void updateFutures$blockTickingToEntityTicking(ChunkMap chunkLoadingManager, Executor executor, CallbackInfo ci) {
        if (this.fabric_currentEventLevelType == FullChunkStatus.BLOCK_TICKING) {
            ((ServerChunkEvents.LevelTypeChange)ServerChunkEvents.CHUNK_LEVEL_TYPE_CHANGE.invoker()).onChunkLevelTypeChange((ServerLevel)this.levelHeightAccessor, (LevelChunk)this.getChunkIfPresentUnchecked(ChunkStatus.FULL), FullChunkStatus.BLOCK_TICKING, FullChunkStatus.ENTITY_TICKING);
            this.fabric_currentEventLevelType = FullChunkStatus.ENTITY_TICKING;
        }
    }

    @Inject(method={"demoteFullChunk"}, at={@At(value="HEAD")})
    private void decreaseLevel(ChunkMap chunkLoadingManager, FullChunkStatus target, CallbackInfo ci) {
        FullChunkStatus previous = ChunkLevel.fullStatus((int)this.oldTicketLevel);
        ServerLevel serverWorld = (ServerLevel)this.levelHeightAccessor;
        for (int i = previous.ordinal(); i > target.ordinal(); --i) {
            FullChunkStatus oldLevelType = fabric_CHUNK_LEVEL_TYPES[i];
            FullChunkStatus newLevelType = fabric_CHUNK_LEVEL_TYPES[i - 1];
            if (!this.fabric_currentEventLevelType.isOrAfter(oldLevelType)) continue;
            ((ServerChunkEvents.LevelTypeChange)ServerChunkEvents.CHUNK_LEVEL_TYPE_CHANGE.invoker()).onChunkLevelTypeChange(serverWorld, (LevelChunk)this.getChunkIfPresentUnchecked(ChunkStatus.FULL), oldLevelType, newLevelType);
            this.fabric_currentEventLevelType = newLevelType;
        }
    }

    @Override
    public void fabric_setCurrentEventLevelType(FullChunkStatus levelType) {
        this.fabric_currentEventLevelType = levelType;
    }

    @Override
    public FullChunkStatus fabric_getCurrentEventLevelType() {
        return this.fabric_currentEventLevelType;
    }
}

