/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.loot;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.fabric.api.loot.v3.LootTableSource;
import net.fabricmc.fabric.impl.resource.pack.BuiltinModResourcePackSource;
import net.fabricmc.fabric.impl.resource.pack.ModResourcePackCreator;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3298;
import net.minecraft.class_52;
import net.minecraft.class_5352;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public final class LootUtil {
	public static final ThreadLocal<Map<class_2960, LootTableSource>> SOURCES = ThreadLocal.withInitial(HashMap::new);

	public static LootTableSource determineSource(class_3298 resource) {
		if (resource != null) {
			class_5352 packSource = resource.getFabricPackSource();

			if (packSource == class_5352.field_25348) {
				return LootTableSource.VANILLA;
			} else if (packSource == ModResourcePackCreator.RESOURCE_PACK_SOURCE || packSource instanceof BuiltinModResourcePackSource) {
				return LootTableSource.MOD;
			}
		}

		// If not builtin or mod, assume external data pack.
		// It might also be a virtual loot table injected via mixin instead of being loaded
		// from a resource, but we can't determine that here.
		return LootTableSource.DATA_PACK;
	}

	public static class_6880<class_52> getEntryOrDirect(class_3218 world, class_52 table) {
		class_7225.class_7874 wrapperLookup = world
				.method_8503()
				.method_58576()
				.method_58294();

		class_7225<class_52> lootTableRegistryWrapper = wrapperLookup
				.method_46759(class_7924.field_50079)
				.orElseThrow(() -> new IllegalStateException("Failed to fetch LootTable wrapper from WrapperLookup"));

		return lootTableRegistryWrapper
				.method_42017()
				.filter(it -> it.comp_349().equals(table))
				.findFirst()
				.map(Function.<class_6880<class_52>>identity())
				.orElseGet(() -> class_6880.method_40223(table));
	}
}
