/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.mining.level;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3494;

public final class ToolManager {
	public interface Entry {
		void setBreakByHand(boolean value);

		void putBreakByTool(class_3494<class_1792> tag, int miningLevel);
	}

	private static class EntryImpl implements Entry {
		@SuppressWarnings("unchecked")
		private class_3494<class_1792>[] tags = new class_3494[0];
		private int[] tagLevels = new int[0];
		private TriState defaultValue = TriState.DEFAULT;

		@Override
		public void setBreakByHand(boolean value) {
			this.defaultValue = TriState.of(value);
		}

		@Override
		public void putBreakByTool(class_3494<class_1792> tag, int miningLevel) {
			for (int i = 0; i < tags.length; i++) {
				if (tags[i] == tag) {
					tagLevels[i] = miningLevel;
					return;
				}
			}

			//noinspection unchecked
			class_3494<class_1792>[] newTags = new class_3494[tags.length + 1];
			int[] newTagLevels = new int[tagLevels.length + 1];
			System.arraycopy(tags, 0, newTags, 0, tags.length);
			System.arraycopy(tagLevels, 0, newTagLevels, 0, tagLevels.length);
			newTags[tags.length] = tag;
			newTagLevels[tagLevels.length] = miningLevel;
			tags = newTags;
			tagLevels = newTagLevels;
		}
	}

	private static final Map<class_2248, EntryImpl> entries = new HashMap<>();

	private ToolManager() { }

	public static Entry entry(class_2248 block) {
		return entries.computeIfAbsent(block, (bb) -> new EntryImpl());
	}

	@Deprecated
	public static void registerBreakByHand(class_2248 block, boolean value) {
		entry(block).setBreakByHand(value);
	}

	@Deprecated
	public static void registerBreakByTool(class_2248 block, class_3494<class_1792> tag, int miningLevel) {
		entry(block).putBreakByTool(tag, miningLevel);
	}

	private static int getMiningLevel(class_1799 stack) {
		if (stack.method_7909() instanceof class_1831) {
			return ((class_1831) stack.method_7909()).method_8022().method_8024();
		} else {
			return 0;
		}
	}

	/**
	 * Hook for ItemStack.isEffectiveOn and similar methods.
	 */
	public static TriState handleIsEffectiveOn(class_1799 stack, class_2680 state) {
		EntryImpl entry = entries.get(state.method_11614());

		if (entry != null) {
			class_1792 item = stack.method_7909();

			for (int i = 0; i < entry.tags.length; i++) {
				if (item.method_7855(entry.tags[i])) {
					return TriState.of(getMiningLevel(stack) >= entry.tagLevels[i]);
				}
			}

			return entry.defaultValue;
		} else {
			return TriState.DEFAULT;
		}
	}
}
